/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.SystemCallContext;
import ru.curs.celesta.dbutils.Action;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.ILoggingManager;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.syscursors.LogCursor;
import ru.curs.celesta.syscursors.LogsetupCursor;

public final class LoggingManager
implements ILoggingManager {
    private static final int CACHE_SIZE = 1024;
    private static final int CACHE_ENTRY_SHELF_LIFE = 20000;
    private final ICelesta celesta;
    private CacheEntry[] cache = new CacheEntry[1024];

    public LoggingManager(ICelesta celesta) {
        this.celesta = celesta;
    }

    boolean isLoggingNeeded(CallContext sysContext, BasicTable t, Action a) {
        int index = CacheEntry.hash(t) & 0x3FF;
        CacheEntry ce = this.cache[index];
        if (ce == null || ce.isExpired() || ce.table != t) {
            this.cache[index] = ce = this.refreshLogging(sysContext, t);
        }
        return ce.isLoggingNeeded(a);
    }

    private CacheEntry refreshLogging(CallContext sysContext, BasicTable t) {
        LogsetupCursor logsetup = new LogsetupCursor(sysContext);
        int loggingMask = 0;
        if (logsetup.tryGet(new Object[]{t.getGrain().getName(), t.getName()})) {
            loggingMask |= logsetup.getI() != false ? Action.INSERT.getMask() : 0;
            loggingMask |= logsetup.getM() != false ? Action.MODIFY.getMask() : 0;
            loggingMask |= logsetup.getD() != false ? Action.DELETE.getMask() : 0;
        }
        return new CacheEntry(t, loggingMask);
    }

    public void log(Cursor c, Action a) {
        if (a == Action.READ) {
            throw new IllegalArgumentException();
        }
        if ("celesta".equals(c.meta().getGrain().getName()) && ("grains".equals(c.meta().getName()) || "tables".equals(c.meta().getName()))) {
            return;
        }
        try (SystemCallContext sysContext = new SystemCallContext(this.celesta, "log");){
            if (!this.isLoggingNeeded((CallContext)sysContext, (BasicTable)c.meta(), a)) {
                return;
            }
            this.writeToLog(c, a, (CallContext)sysContext);
        }
    }

    private void writeToLog(Cursor c, Action a, CallContext sysContext) {
        int len;
        String value;
        LogCursor log = new LogCursor(sysContext);
        log.init();
        log.setUserid(((CallContext)c.callContext()).getUserId());
        log.setGrainid(c.meta().getGrain().getName());
        log.setTablename(c._objectName());
        log.setAction_type(a.shortId());
        Object[] o = c._currentKeyValues();
        if (o.length > 0) {
            value = o[0] == null ? "NULL" : o[0].toString();
            len = log.getMaxStrLen(log.COLUMNS.pkvalue1());
            log.setPkvalue1(LoggingManager.trimValue(value, len));
        }
        if (o.length > 1) {
            value = o[1] == null ? "NULL" : o[1].toString();
            len = log.getMaxStrLen(log.COLUMNS.pkvalue2());
            log.setPkvalue2(LoggingManager.trimValue(value, len));
        }
        if (o.length > 2) {
            value = o[2] == null ? "NULL" : o[2].toString();
            len = log.getMaxStrLen(log.COLUMNS.pkvalue3());
            log.setPkvalue3(LoggingManager.trimValue(value, len));
        }
        len = log.getMaxStrLen(log.COLUMNS.newvalues());
        switch (a) {
            case INSERT: {
                value = c.asCSVLine();
                log.setNewvalues(LoggingManager.trimValue(value, len));
                break;
            }
            case MODIFY: {
                value = c.asCSVLine();
                log.setNewvalues(LoggingManager.trimValue(value, len));
                value = c.getXRec().asCSVLine();
                log.setOldvalues(LoggingManager.trimValue(value, len));
                break;
            }
            case DELETE: {
                value = c.getXRec().asCSVLine();
                log.setOldvalues(LoggingManager.trimValue(value, len));
                break;
            }
        }
        log.insert();
    }

    private static String trimValue(String value, int len) {
        return value.length() > len ? value.substring(0, len) : value;
    }

    private static class CacheEntry {
        private final BasicTable table;
        private final int loggingMask;
        private final long expirationTime;

        CacheEntry(BasicTable table, int loggingMask) {
            this.table = table;
            this.loggingMask = loggingMask;
            this.expirationTime = System.currentTimeMillis() + 20000L;
        }

        public static int hash(BasicTable table) {
            return (table.getGrain().getName() + '|' + table.getName()).hashCode();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expirationTime;
        }

        public boolean isLoggingNeeded(Action a) {
            if (a == Action.READ) {
                throw new IllegalArgumentException();
            }
            return (this.loggingMask & a.getMask()) != 0;
        }
    }
}

