package ru.curs.celesta.syscursors;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Generated;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.CelestaGenerated;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.CursorIterator;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.Table;

@Generated(
        value = "ru.curs.celesta.plugin.maven.CursorGenerator",
        date = "2021-08-26T05:34:05.408"
)
@CelestaGenerated
public class SessionlogCursor extends Cursor implements Iterable<SessionlogCursor> {
    private static final String GRAIN_NAME = "celesta";

    private static final String OBJECT_NAME = "sessionlog";

    public static final String TABLE_NAME = OBJECT_NAME;

    public final SessionlogCursor.Columns COLUMNS;

    private Integer entryno;

    private String sessionid;

    private String userid;

    private Date logintime;

    private Date logoutime;

    private Boolean timeout;

    private Boolean failedlogin;

    {
        this.COLUMNS = new SessionlogCursor.Columns(callContext().getCelesta());
    }

    public SessionlogCursor(CallContext context) {
        super(context);
    }

    public SessionlogCursor(CallContext context, ColumnMeta<?>... columns) {
        super(context, columns);
    }

    @Deprecated
    public SessionlogCursor(CallContext context, Set<String> fields) {
        super(context, fields);
    }

    public Integer getEntryno() {
        return this.entryno;
    }

    public SessionlogCursor setEntryno(Integer entryno) {
        this.entryno = entryno;
        return this;
    }

    public String getSessionid() {
        return this.sessionid;
    }

    public SessionlogCursor setSessionid(String sessionid) {
        this.sessionid = sessionid;
        return this;
    }

    public String getUserid() {
        return this.userid;
    }

    public SessionlogCursor setUserid(String userid) {
        this.userid = userid;
        return this;
    }

    public Date getLogintime() {
        return this.logintime;
    }

    public SessionlogCursor setLogintime(Date logintime) {
        this.logintime = logintime;
        return this;
    }

    public Date getLogoutime() {
        return this.logoutime;
    }

    public SessionlogCursor setLogoutime(Date logoutime) {
        this.logoutime = logoutime;
        return this;
    }

    public Boolean getTimeout() {
        return this.timeout;
    }

    public SessionlogCursor setTimeout(Boolean timeout) {
        this.timeout = timeout;
        return this;
    }

    public Boolean getFailedlogin() {
        return this.failedlogin;
    }

    public SessionlogCursor setFailedlogin(Boolean failedlogin) {
        this.failedlogin = failedlogin;
        return this;
    }

    @Override
    protected Object _getFieldValue(String name) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            return f.get(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void _setFieldValue(String name, Object value) {
        try {
            Field f = getClass().getDeclaredField(name);
            f.setAccessible(true);
            f.set(this, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object[] _currentKeyValues() {
        return new Object[] {entryno};
    }

    public boolean tryGet(Integer entryno) {
        return tryGetByValuesArray(entryno);
    }

    public void get(Integer entryno) {
        getByValuesArray(entryno);
    }

    @Override
    protected void _parseResultInternal(ResultSet rs) throws SQLException {
        if (this.inRec("entryno")) {
            this.entryno = rs.getInt("entryno");
            if (rs.wasNull()) {
                this.entryno = null;
            }
        }
        if (this.inRec("sessionid")) {
            this.sessionid = rs.getString("sessionid");
            if (rs.wasNull()) {
                this.sessionid = null;
            }
        }
        if (this.inRec("userid")) {
            this.userid = rs.getString("userid");
            if (rs.wasNull()) {
                this.userid = null;
            }
        }
        if (this.inRec("logintime")) {
            this.logintime = rs.getTimestamp("logintime");
            if (rs.wasNull()) {
                this.logintime = null;
            }
        }
        if (this.inRec("logoutime")) {
            this.logoutime = rs.getTimestamp("logoutime");
            if (rs.wasNull()) {
                this.logoutime = null;
            }
        }
        if (this.inRec("timeout")) {
            this.timeout = rs.getBoolean("timeout");
            if (rs.wasNull()) {
                this.timeout = null;
            }
        }
        if (this.inRec("failedlogin")) {
            this.failedlogin = rs.getBoolean("failedlogin");
            if (rs.wasNull()) {
                this.failedlogin = null;
            }
        }
    }

    @Override
    public void _clearBuffer(boolean withKeys) {
        if (withKeys) {
            this.entryno = null;
        }
        this.sessionid = null;
        this.userid = null;
        this.logintime = null;
        this.logoutime = null;
        this.timeout = null;
        this.failedlogin = null;
    }

    @Override
    public Object[] _currentValues() {
        return new Object[] {entryno, sessionid, userid, logintime, logoutime, timeout, failedlogin};
    }

    @Override
    protected void _setAutoIncrement(int val) {
        this.entryno = val;
    }

    public static void onPreDelete(ICelesta celesta,
            Consumer<? super SessionlogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_DELETE, SessionlogCursor.class, cursorConsumer);
    }

    public static void onPostDelete(ICelesta celesta,
            Consumer<? super SessionlogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_DELETE, SessionlogCursor.class, cursorConsumer);
    }

    public static void onPreInsert(ICelesta celesta,
            Consumer<? super SessionlogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_INSERT, SessionlogCursor.class, cursorConsumer);
    }

    public static void onPostInsert(ICelesta celesta,
            Consumer<? super SessionlogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_INSERT, SessionlogCursor.class, cursorConsumer);
    }

    public static void onPreUpdate(ICelesta celesta,
            Consumer<? super SessionlogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_UPDATE, SessionlogCursor.class, cursorConsumer);
    }

    public static void onPostUpdate(ICelesta celesta,
            Consumer<? super SessionlogCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_UPDATE, SessionlogCursor.class, cursorConsumer);
    }

    @Override
    public SessionlogCursor _getBufferCopy(CallContext context, List<String> fields) {
        final SessionlogCursor result;
        if (Objects.isNull(fields)) {
            result = new SessionlogCursor(context);
        }
        else {
            result = new SessionlogCursor(context, new LinkedHashSet<>(fields));
        }
        result.copyFieldsFrom(this);
        return result;
    }

    @Override
    public void copyFieldsFrom(BasicCursor c) {
        SessionlogCursor from = (SessionlogCursor)c;
        this.entryno = from.entryno;
        this.sessionid = from.sessionid;
        this.userid = from.userid;
        this.logintime = from.logintime;
        this.logoutime = from.logoutime;
        this.timeout = from.timeout;
        this.failedlogin = from.failedlogin;
    }

    @Override
    public Iterator<SessionlogCursor> iterator() {
        return new CursorIterator<SessionlogCursor>(this);
    }

    @Override
    protected String _grainName() {
        return GRAIN_NAME;
    }

    @Override
    protected String _objectName() {
        return OBJECT_NAME;
    }

    @SuppressWarnings("unchecked")
    @Generated(
            value = "ru.curs.celesta.plugin.maven.CursorGenerator",
            date = "2021-08-26T05:34:05.409"
    )
    @CelestaGenerated
    public static final class Columns {
        private final Table element;

        public Columns(ICelesta celesta) {
            this.element = celesta.getScore().getGrains().get(GRAIN_NAME).getElements(Table.class).get(OBJECT_NAME);
        }

        public ColumnMeta<Integer> entryno() {
            return (ColumnMeta<Integer>) this.element.getColumns().get("entryno");
        }

        public ColumnMeta<String> sessionid() {
            return (ColumnMeta<String>) this.element.getColumns().get("sessionid");
        }

        public ColumnMeta<String> userid() {
            return (ColumnMeta<String>) this.element.getColumns().get("userid");
        }

        public ColumnMeta<Date> logintime() {
            return (ColumnMeta<Date>) this.element.getColumns().get("logintime");
        }

        public ColumnMeta<Date> logoutime() {
            return (ColumnMeta<Date>) this.element.getColumns().get("logoutime");
        }

        public ColumnMeta<Boolean> timeout() {
            return (ColumnMeta<Boolean>) this.element.getColumns().get("timeout");
        }

        public ColumnMeta<Boolean> failedlogin() {
            return (ColumnMeta<Boolean>) this.element.getColumns().get("failedlogin");
        }
    }
}
