package ru.curs.celesta.syscursors;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Generated;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.CelestaGenerated;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.CursorIterator;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.Table;

@Generated(
        value = "ru.curs.celesta.plugin.maven.CursorGenerator",
        date = "2022-08-21T00:37:45.815"
)
@CelestaGenerated
public class LogsetupCursor extends Cursor implements Iterable<LogsetupCursor> {
    private static final String GRAIN_NAME = "celesta";

    private static final String OBJECT_NAME = "logsetup";

    public static final String TABLE_NAME = OBJECT_NAME;

    public final LogsetupCursor.Columns COLUMNS;

    private String grainid;

    private String tablename;

    private Boolean i;

    private Boolean m;

    private Boolean d;

    {
        this.COLUMNS = new LogsetupCursor.Columns(callContext().getCelesta());
    }

    public LogsetupCursor(CallContext context) {
        super(context);
    }

    public LogsetupCursor(CallContext context, ColumnMeta<?>... columns) {
        super(context, columns);
    }

    @Deprecated
    public LogsetupCursor(CallContext context, Set<String> fields) {
        super(context, fields);
    }

    public String getGrainid() {
        return this.grainid;
    }

    public LogsetupCursor setGrainid(String grainid) {
        this.grainid = grainid;
        return this;
    }

    public String getTablename() {
        return this.tablename;
    }

    public LogsetupCursor setTablename(String tablename) {
        this.tablename = tablename;
        return this;
    }

    public Boolean getI() {
        return this.i;
    }

    public LogsetupCursor setI(Boolean i) {
        this.i = i;
        return this;
    }

    public Boolean getM() {
        return this.m;
    }

    public LogsetupCursor setM(Boolean m) {
        this.m = m;
        return this;
    }

    public Boolean getD() {
        return this.d;
    }

    public LogsetupCursor setD(Boolean d) {
        this.d = d;
        return this;
    }

    @Override
    protected Object _getFieldValue(String name) {
        switch (name) {
            case "grainid": return this.grainid;
            case "tablename": return this.tablename;
            case "i": return this.i;
            case "m": return this.m;
            case "d": return this.d;
            default: return null;
        }
    }

    @Override
    protected void _setFieldValue(String name, Object value) {
        switch (name) {
            case "grainid": {
                this.grainid = (String) value;
                break;
            }
            case "tablename": {
                this.tablename = (String) value;
                break;
            }
            case "i": {
                this.i = (Boolean) value;
                break;
            }
            case "m": {
                this.m = (Boolean) value;
                break;
            }
            case "d": {
                this.d = (Boolean) value;
                break;
            }
            default:;
        }
    }

    @Override
    protected Object[] _currentKeyValues() {
        return new Object[] {grainid, tablename};
    }

    public boolean tryGet(String grainid, String tablename) {
        return tryGetByValuesArray(grainid, tablename);
    }

    public void get(String grainid, String tablename) {
        getByValuesArray(grainid, tablename);
    }

    @Override
    protected void _parseResultInternal(ResultSet rs) throws SQLException {
        if (this.inRec("grainid")) {
            this.grainid = rs.getString("grainid");
            if (rs.wasNull()) {
                this.grainid = null;
            }
        }
        if (this.inRec("tablename")) {
            this.tablename = rs.getString("tablename");
            if (rs.wasNull()) {
                this.tablename = null;
            }
        }
        if (this.inRec("i")) {
            this.i = rs.getBoolean("i");
            if (rs.wasNull()) {
                this.i = null;
            }
        }
        if (this.inRec("m")) {
            this.m = rs.getBoolean("m");
            if (rs.wasNull()) {
                this.m = null;
            }
        }
        if (this.inRec("d")) {
            this.d = rs.getBoolean("d");
            if (rs.wasNull()) {
                this.d = null;
            }
        }
        this.setRecversion(rs.getInt("recversion"));
    }

    @Override
    public void _clearBuffer(boolean withKeys) {
        if (withKeys) {
            this.grainid = null;
            this.tablename = null;
        }
        this.i = null;
        this.m = null;
        this.d = null;
    }

    @Override
    public Object[] _currentValues() {
        return new Object[] {grainid, tablename, i, m, d};
    }

    @Override
    protected void _setAutoIncrement(int val) {
    }

    public static void onPreDelete(ICelesta celesta,
            Consumer<? super LogsetupCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_DELETE, LogsetupCursor.class, cursorConsumer);
    }

    public static void onPostDelete(ICelesta celesta,
            Consumer<? super LogsetupCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_DELETE, LogsetupCursor.class, cursorConsumer);
    }

    public static void onPreInsert(ICelesta celesta,
            Consumer<? super LogsetupCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_INSERT, LogsetupCursor.class, cursorConsumer);
    }

    public static void onPostInsert(ICelesta celesta,
            Consumer<? super LogsetupCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_INSERT, LogsetupCursor.class, cursorConsumer);
    }

    public static void onPreUpdate(ICelesta celesta,
            Consumer<? super LogsetupCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_UPDATE, LogsetupCursor.class, cursorConsumer);
    }

    public static void onPostUpdate(ICelesta celesta,
            Consumer<? super LogsetupCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_UPDATE, LogsetupCursor.class, cursorConsumer);
    }

    @Override
    public LogsetupCursor _getBufferCopy(CallContext context, List<String> fields) {
        final LogsetupCursor result;
        if (Objects.isNull(fields)) {
            result = new LogsetupCursor(context);
        }
        else {
            result = new LogsetupCursor(context, new LinkedHashSet<>(fields));
        }
        result.copyFieldsFrom(this);
        return result;
    }

    @Override
    public void copyFieldsFrom(BasicCursor c) {
        LogsetupCursor from = (LogsetupCursor)c;
        this.grainid = from.grainid;
        this.tablename = from.tablename;
        this.i = from.i;
        this.m = from.m;
        this.d = from.d;
        this.setRecversion(from.getRecversion());
    }

    @Override
    public Iterator<LogsetupCursor> iterator() {
        return new CursorIterator<LogsetupCursor>(this);
    }

    @Override
    protected String _grainName() {
        return GRAIN_NAME;
    }

    @Override
    protected String _objectName() {
        return OBJECT_NAME;
    }

    @SuppressWarnings("unchecked")
    @Generated(
            value = "ru.curs.celesta.plugin.maven.CursorGenerator",
            date = "2022-08-21T00:37:45.816"
    )
    @CelestaGenerated
    public static final class Columns {
        private final Table element;

        public Columns(ICelesta celesta) {
            this.element = celesta.getScore().getGrains().get(GRAIN_NAME).getElements(Table.class).get(OBJECT_NAME);
        }

        public ColumnMeta<String> grainid() {
            return (ColumnMeta<String>) this.element.getColumns().get("grainid");
        }

        public ColumnMeta<String> tablename() {
            return (ColumnMeta<String>) this.element.getColumns().get("tablename");
        }

        public ColumnMeta<Boolean> i() {
            return (ColumnMeta<Boolean>) this.element.getColumns().get("i");
        }

        public ColumnMeta<Boolean> m() {
            return (ColumnMeta<Boolean>) this.element.getColumns().get("m");
        }

        public ColumnMeta<Boolean> d() {
            return (ColumnMeta<Boolean>) this.element.getColumns().get("d");
        }
    }
}
