package ru.curs.celesta.syscursors;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Generated;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.CelestaGenerated;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.CursorIterator;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.Table;

@Generated(
        value = "ru.curs.celesta.plugin.maven.CursorGenerator",
        date = "2022-10-02T00:37:50.037"
)
@CelestaGenerated
public class PermissionsCursor extends Cursor implements Iterable<PermissionsCursor> {
    private static final String GRAIN_NAME = "celesta";

    private static final String OBJECT_NAME = "permissions";

    public static final String TABLE_NAME = OBJECT_NAME;

    public final PermissionsCursor.Columns COLUMNS;

    private String roleid;

    private String grainid;

    private String tablename;

    private Boolean r;

    private Boolean i;

    private Boolean m;

    private Boolean d;

    {
        this.COLUMNS = new PermissionsCursor.Columns(callContext().getCelesta());
    }

    public PermissionsCursor(CallContext context) {
        super(context);
    }

    public PermissionsCursor(CallContext context, ColumnMeta<?>... columns) {
        super(context, columns);
    }

    @Deprecated
    public PermissionsCursor(CallContext context, Set<String> fields) {
        super(context, fields);
    }

    public String getRoleid() {
        return this.roleid;
    }

    public PermissionsCursor setRoleid(String roleid) {
        this.roleid = roleid;
        return this;
    }

    public String getGrainid() {
        return this.grainid;
    }

    public PermissionsCursor setGrainid(String grainid) {
        this.grainid = grainid;
        return this;
    }

    public String getTablename() {
        return this.tablename;
    }

    public PermissionsCursor setTablename(String tablename) {
        this.tablename = tablename;
        return this;
    }

    public Boolean getR() {
        return this.r;
    }

    public PermissionsCursor setR(Boolean r) {
        this.r = r;
        return this;
    }

    public Boolean getI() {
        return this.i;
    }

    public PermissionsCursor setI(Boolean i) {
        this.i = i;
        return this;
    }

    public Boolean getM() {
        return this.m;
    }

    public PermissionsCursor setM(Boolean m) {
        this.m = m;
        return this;
    }

    public Boolean getD() {
        return this.d;
    }

    public PermissionsCursor setD(Boolean d) {
        this.d = d;
        return this;
    }

    @Override
    protected Object _getFieldValue(String name) {
        switch (name) {
            case "roleid": return this.roleid;
            case "grainid": return this.grainid;
            case "tablename": return this.tablename;
            case "r": return this.r;
            case "i": return this.i;
            case "m": return this.m;
            case "d": return this.d;
            default: return null;
        }
    }

    @Override
    protected void _setFieldValue(String name, Object value) {
        switch (name) {
            case "roleid": {
                this.roleid = (String) value;
                break;
            }
            case "grainid": {
                this.grainid = (String) value;
                break;
            }
            case "tablename": {
                this.tablename = (String) value;
                break;
            }
            case "r": {
                this.r = (Boolean) value;
                break;
            }
            case "i": {
                this.i = (Boolean) value;
                break;
            }
            case "m": {
                this.m = (Boolean) value;
                break;
            }
            case "d": {
                this.d = (Boolean) value;
                break;
            }
            default:;
        }
    }

    @Override
    protected Object[] _currentKeyValues() {
        return new Object[] {roleid, grainid, tablename};
    }

    public boolean tryGet(String roleid, String grainid, String tablename) {
        return tryGetByValuesArray(roleid, grainid, tablename);
    }

    public void get(String roleid, String grainid, String tablename) {
        getByValuesArray(roleid, grainid, tablename);
    }

    @Override
    protected void _parseResultInternal(ResultSet rs) throws SQLException {
        if (this.inRec("roleid")) {
            this.roleid = rs.getString("roleid");
            if (rs.wasNull()) {
                this.roleid = null;
            }
        }
        if (this.inRec("grainid")) {
            this.grainid = rs.getString("grainid");
            if (rs.wasNull()) {
                this.grainid = null;
            }
        }
        if (this.inRec("tablename")) {
            this.tablename = rs.getString("tablename");
            if (rs.wasNull()) {
                this.tablename = null;
            }
        }
        if (this.inRec("r")) {
            this.r = rs.getBoolean("r");
            if (rs.wasNull()) {
                this.r = null;
            }
        }
        if (this.inRec("i")) {
            this.i = rs.getBoolean("i");
            if (rs.wasNull()) {
                this.i = null;
            }
        }
        if (this.inRec("m")) {
            this.m = rs.getBoolean("m");
            if (rs.wasNull()) {
                this.m = null;
            }
        }
        if (this.inRec("d")) {
            this.d = rs.getBoolean("d");
            if (rs.wasNull()) {
                this.d = null;
            }
        }
        this.setRecversion(rs.getInt("recversion"));
    }

    @Override
    public void _clearBuffer(boolean withKeys) {
        if (withKeys) {
            this.roleid = null;
            this.grainid = null;
            this.tablename = null;
        }
        this.r = null;
        this.i = null;
        this.m = null;
        this.d = null;
    }

    @Override
    public Object[] _currentValues() {
        return new Object[] {roleid, grainid, tablename, r, i, m, d};
    }

    @Override
    protected void _setAutoIncrement(int val) {
    }

    public static void onPreDelete(ICelesta celesta,
            Consumer<? super PermissionsCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_DELETE, PermissionsCursor.class, cursorConsumer);
    }

    public static void onPostDelete(ICelesta celesta,
            Consumer<? super PermissionsCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_DELETE, PermissionsCursor.class, cursorConsumer);
    }

    public static void onPreInsert(ICelesta celesta,
            Consumer<? super PermissionsCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_INSERT, PermissionsCursor.class, cursorConsumer);
    }

    public static void onPostInsert(ICelesta celesta,
            Consumer<? super PermissionsCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_INSERT, PermissionsCursor.class, cursorConsumer);
    }

    public static void onPreUpdate(ICelesta celesta,
            Consumer<? super PermissionsCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_UPDATE, PermissionsCursor.class, cursorConsumer);
    }

    public static void onPostUpdate(ICelesta celesta,
            Consumer<? super PermissionsCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_UPDATE, PermissionsCursor.class, cursorConsumer);
    }

    @Override
    public PermissionsCursor _getBufferCopy(CallContext context, List<String> fields) {
        final PermissionsCursor result;
        if (Objects.isNull(fields)) {
            result = new PermissionsCursor(context);
        }
        else {
            result = new PermissionsCursor(context, new LinkedHashSet<>(fields));
        }
        result.copyFieldsFrom(this);
        return result;
    }

    @Override
    public void copyFieldsFrom(BasicCursor c) {
        PermissionsCursor from = (PermissionsCursor)c;
        this.roleid = from.roleid;
        this.grainid = from.grainid;
        this.tablename = from.tablename;
        this.r = from.r;
        this.i = from.i;
        this.m = from.m;
        this.d = from.d;
        this.setRecversion(from.getRecversion());
    }

    @Override
    public Iterator<PermissionsCursor> iterator() {
        return new CursorIterator<PermissionsCursor>(this);
    }

    @Override
    protected String _grainName() {
        return GRAIN_NAME;
    }

    @Override
    protected String _objectName() {
        return OBJECT_NAME;
    }

    @SuppressWarnings("unchecked")
    @Generated(
            value = "ru.curs.celesta.plugin.maven.CursorGenerator",
            date = "2022-10-02T00:37:50.039"
    )
    @CelestaGenerated
    public static final class Columns {
        private final Table element;

        public Columns(ICelesta celesta) {
            this.element = celesta.getScore().getGrains().get(GRAIN_NAME).getElements(Table.class).get(OBJECT_NAME);
        }

        public ColumnMeta<String> roleid() {
            return (ColumnMeta<String>) this.element.getColumns().get("roleid");
        }

        public ColumnMeta<String> grainid() {
            return (ColumnMeta<String>) this.element.getColumns().get("grainid");
        }

        public ColumnMeta<String> tablename() {
            return (ColumnMeta<String>) this.element.getColumns().get("tablename");
        }

        public ColumnMeta<Boolean> r() {
            return (ColumnMeta<Boolean>) this.element.getColumns().get("r");
        }

        public ColumnMeta<Boolean> i() {
            return (ColumnMeta<Boolean>) this.element.getColumns().get("i");
        }

        public ColumnMeta<Boolean> m() {
            return (ColumnMeta<Boolean>) this.element.getColumns().get("m");
        }

        public ColumnMeta<Boolean> d() {
            return (ColumnMeta<Boolean>) this.element.getColumns().get("d");
        }
    }
}
