/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import java.util.ArrayList;
import java.util.List;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.SystemCallContext;
import ru.curs.celesta.dbutils.Action;
import ru.curs.celesta.dbutils.IPermissionManager;
import ru.curs.celesta.score.GrainElement;
import ru.curs.celesta.syscursors.PermissionsCursor;
import ru.curs.celesta.syscursors.UserrolesCursor;

public final class PermissionManager
implements IPermissionManager {
    private static final int CACHE_SIZE = 8192;
    private static final int ROLE_CACHE_SIZE = 2048;
    private static final int CACHE_ENTRY_SHELF_LIFE = 20000;
    private static final int FULL_RIGHTS = Action.READ.getMask() | Action.INSERT.getMask() | Action.MODIFY.getMask() | Action.DELETE.getMask();
    private final ICelesta celesta;
    private PermissionCacheEntry[] cache = new PermissionCacheEntry[8192];
    private RoleCacheEntry[] rolesCache = new RoleCacheEntry[2048];

    public PermissionManager(ICelesta celesta) {
        this.celesta = celesta;
    }

    public boolean isActionAllowed(CallContext c, GrainElement t, Action a) {
        if (c instanceof SystemCallContext) {
            return true;
        }
        int index = PermissionCacheEntry.hash(c.getUserId(), t) & 0x1FFF;
        PermissionCacheEntry ce = this.cache[index];
        if (ce == null || ce.isExpired() || ce.table != t || !ce.userName.equals(c.getUserId())) {
            this.cache[index] = ce = this.refreshPermissions(c, t);
        }
        return ce.isActionPermitted(a);
    }

    private RoleCacheEntry getRce(String userID, CallContext sysContext) {
        int index = userID.hashCode() & 0x7FF;
        RoleCacheEntry rce = this.rolesCache[index];
        if (rce == null || rce.isExpired() || !rce.userId.equals(userID)) {
            rce = new RoleCacheEntry(userID);
            UserrolesCursor userRoles = new UserrolesCursor(sysContext);
            userRoles.setRange(userRoles.COLUMNS.userid(), userID);
            while (userRoles.nextInSet()) {
                rce.roles.add(userRoles.getRoleid());
            }
            this.rolesCache[index] = rce;
        }
        return rce;
    }

    private PermissionCacheEntry refreshPermissions(CallContext c, GrainElement t) {
        try (SystemCallContext sysContext = new SystemCallContext(this.celesta, "refreshPermissions");){
            RoleCacheEntry rce = this.getRce(c.getUserId(), (CallContext)sysContext);
            PermissionsCursor permissions = new PermissionsCursor((CallContext)sysContext);
            int permissionsMask = 0;
            for (String roleId : rce.roles) {
                if (permissionsMask == FULL_RIGHTS) break;
                if ("reader".equals(roleId) || (t.getGrain().getName() + '.' + "reader").equals(roleId)) {
                    permissionsMask |= Action.READ.getMask();
                    continue;
                }
                if ("editor".equals(roleId) || (t.getGrain().getName() + '.' + "editor").equals(roleId)) {
                    permissionsMask = FULL_RIGHTS;
                    continue;
                }
                if (!permissions.tryGet(roleId, t.getGrain().getName(), t.getName())) continue;
                permissionsMask |= permissions.getR() != false ? Action.READ.getMask() : 0;
                permissionsMask |= permissions.getI() != false ? Action.INSERT.getMask() : 0;
                permissionsMask |= permissions.getM() != false ? Action.MODIFY.getMask() : 0;
                permissionsMask |= permissions.getD() != false ? Action.DELETE.getMask() : 0;
            }
            PermissionCacheEntry permissionCacheEntry = new PermissionCacheEntry(c.getUserId(), t, permissionsMask);
            return permissionCacheEntry;
        }
    }

    private static class RoleCacheEntry
    extends BaseCacheEntry {
        private final String userId;
        private final List<String> roles = new ArrayList<String>();

        RoleCacheEntry(String userId) {
            this.userId = userId;
        }
    }

    private static class PermissionCacheEntry
    extends BaseCacheEntry {
        private final String userName;
        private final GrainElement table;
        private final int permissionMask;

        PermissionCacheEntry(String userName, GrainElement table, int permissionMask) {
            if (userName == null) {
                throw new IllegalArgumentException();
            }
            this.userName = userName;
            this.table = table;
            this.permissionMask = permissionMask;
        }

        public static int hash(String userName, GrainElement table) {
            return (userName + '|' + table.getGrain().getName() + '|' + table.getName()).hashCode();
        }

        public boolean isActionPermitted(Action a) {
            return (this.permissionMask & a.getMask()) != 0;
        }
    }

    private static class BaseCacheEntry {
        private final long expirationTime = System.currentTimeMillis() + 20000L;

        BaseCacheEntry() {
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expirationTime;
        }
    }
}

