/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import org.h2.tools.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.AppSettings;
import ru.curs.celesta.BaseAppSettings;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.ConnectionPoolConfiguration;
import ru.curs.celesta.DatasourceConnectionPool;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.InternalConnectionPool;
import ru.curs.celesta.PasswordHider;
import ru.curs.celesta.dbutils.DbUpdaterBuilder;
import ru.curs.celesta.dbutils.DbUpdaterImpl;
import ru.curs.celesta.dbutils.ILoggingManager;
import ru.curs.celesta.dbutils.IPermissionManager;
import ru.curs.celesta.dbutils.IProfiler;
import ru.curs.celesta.dbutils.LoggingManager;
import ru.curs.celesta.dbutils.PermissionManager;
import ru.curs.celesta.dbutils.ProfilingManager;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.configuration.DbAdaptorFactory;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlConsumer;
import ru.curs.celesta.dbutils.adaptors.ddl.JdbcDdlConsumer;
import ru.curs.celesta.dbutils.h2.AbstractMaterializedViewTrigger;
import ru.curs.celesta.event.TriggerDispatcher;
import ru.curs.celesta.score.AbstractScore;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.Score;
import ru.curs.celesta.score.discovery.ScoreByScorePathDiscovery;
import ru.curs.celesta.score.discovery.ScoreByScoreResourceDiscovery;
import ru.curs.celesta.score.discovery.ScoreDiscovery;
import ru.curs.celesta.ver.CelestaVersion;

public final class Celesta
implements ICelesta {
    public static final String VERSION = CelestaVersion.VERSION;
    private static final String FILE_PROPERTIES = "celesta.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(Celesta.class);
    private final BaseAppSettings appSettings;
    private final Score score;
    private final ConnectionPool connectionPool;
    private final DBAdaptor dbAdaptor;
    private final TriggerDispatcher triggerDispatcher = new TriggerDispatcher();
    private final Server server;
    private final LoggingManager loggingManager;
    private final PermissionManager permissionManager;
    private final ProfilingManager profiler;

    private Celesta(BaseAppSettings appSettings, ConnectionPool connectionPool) {
        this.appSettings = appSettings;
        this.connectionPool = connectionPool;
        this.server = this.manageH2Server();
        LOGGER.info("Celesta initialization: score parsing...");
        try {
            ScoreByScoreResourceDiscovery scoreDiscovery = this.appSettings.getScorePath().isEmpty() ? new ScoreByScoreResourceDiscovery() : new ScoreByScorePathDiscovery(appSettings.getScorePath());
            this.score = (Score)new AbstractScore.ScoreBuilder(Score.class).scoreDiscovery((ScoreDiscovery)scoreDiscovery).build();
        }
        catch (ParseException e) {
            throw new CelestaException((Throwable)e);
        }
        AbstractMaterializedViewTrigger.initScore((AbstractScore)this.score);
        LOGGER.info("done.");
        LOGGER.info(this.score.describeGrains());
        DbAdaptorFactory dac = new DbAdaptorFactory().setDbType(appSettings.getDBType()).setDdlConsumer((DdlConsumer)new JdbcDdlConsumer()).setConnectionPool(connectionPool).setH2ReferentialIntegrity(appSettings.isH2ReferentialIntegrity());
        this.dbAdaptor = dac.createDbAdaptor();
        this.loggingManager = new LoggingManager(this);
        this.permissionManager = new PermissionManager(this);
        this.profiler = new ProfilingManager(this);
        if (!appSettings.getSkipDBUpdate()) {
            LOGGER.info("Celesta initialization: database {} upgrade...", (Object)PasswordHider.maskPassword((String)appSettings.getDatabaseConnection()));
            DbUpdaterImpl dbUpdater = new DbUpdaterBuilder().dbAdaptor(this.dbAdaptor).connectionPool(connectionPool).score(this.score).forceDdInitialize(appSettings.getForceDBInitialize()).setCelesta(this).build();
            dbUpdater.updateDb();
            LOGGER.info("done.");
        } else {
            LOGGER.info("Celesta initialization: database upgrade...skipped.");
        }
    }

    public Properties getSetupProperties() {
        return this.appSettings.getSetupProperties();
    }

    public IPermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public ILoggingManager getLoggingManager() {
        return this.loggingManager;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public IProfiler getProfiler() {
        return this.profiler;
    }

    public DBAdaptor getDBAdaptor() {
        return this.dbAdaptor;
    }

    public TriggerDispatcher getTriggerDispatcher() {
        return this.triggerDispatcher;
    }

    public Score getScore() {
        return this.score;
    }

    public void close() {
        this.connectionPool.close();
        Optional.ofNullable(this.server).ifPresent(Server::shutdown);
    }

    public static Celesta createInstance(Properties properties, DataSource dataSource) {
        return Celesta.createInstance(properties, (ConnectionPool)new DatasourceConnectionPool(dataSource));
    }

    public static Celesta createInstance(Properties properties, ConnectionPool connectionPool) {
        AppSettings appSettings = Celesta.preInit(properties);
        return new Celesta(appSettings, connectionPool);
    }

    public static Celesta createInstance(Properties properties) {
        AppSettings appSettings = Celesta.preInit(properties);
        ConnectionPoolConfiguration cpc = new ConnectionPoolConfiguration();
        cpc.setJdbcConnectionUrl(appSettings.getDatabaseConnection());
        cpc.setLogin(appSettings.getDBLogin());
        cpc.setPassword(appSettings.getDBPassword());
        return new Celesta(appSettings, (ConnectionPool)InternalConnectionPool.create((ConnectionPoolConfiguration)cpc));
    }

    public static Celesta createInstance() {
        Properties properties = Celesta.loadPropertiesDynamically();
        return Celesta.createInstance(properties);
    }

    private static AppSettings preInit(Properties properties) {
        LOGGER.info("Celesta ver. {}", (Object)(VERSION != null ? VERSION : "N/A (invalid build?)"));
        LOGGER.info("Celesta pre-initialization: system settings reading...");
        AppSettings appSettings = new AppSettings(properties);
        LOGGER.info("done.");
        return appSettings;
    }

    public static Properties loadPropertiesDynamically() {
        Properties properties = new Properties();
        try {
            InputStream in;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try (InputStream inputStream = in = loader.getResourceAsStream(FILE_PROPERTIES);){
                if (in == null) {
                    throw new CelestaException(String.format("Couldn't find file %s on classpath.", FILE_PROPERTIES));
                }
                properties.load(in);
            }
        }
        catch (IOException e) {
            throw new CelestaException(String.format("IOException while reading %s file: %s", FILE_PROPERTIES, e.getMessage()));
        }
        return properties;
    }

    private Server manageH2Server() {
        Server result;
        if (this.appSettings.getH2Port() > 0) {
            try {
                LOGGER.info("H2 server starting on port {}...", (Object)this.appSettings.getH2Port());
                result = Server.createTcpServer((String[])new String[]{"-tcpPort", Integer.toString(this.appSettings.getH2Port()), "-ifNotExists", "-tcpAllowOthers"}).start();
                LOGGER.info("done.");
            }
            catch (SQLException e) {
                throw new CelestaException((Throwable)e);
            }
        } else {
            result = null;
        }
        return result;
    }

    public boolean isProfilemode() {
        return this.profiler.isProfilemode();
    }

    public boolean nullsFirst() {
        return this.dbAdaptor.nullsFirst();
    }

    public void setProfilemode(boolean profilemode) {
        this.profiler.setProfilemode(profilemode);
    }
}

