package ru.curs.celesta.syscursors;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Generated;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.CelestaGenerated;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.celesta.dbutils.CursorIterator;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.Table;

@Generated(
        value = "ru.curs.celesta.plugin.maven.CursorGenerator",
        date = "2025-05-12T14:12:45.7518922"
)
@CelestaGenerated
public class RolesCursor extends Cursor implements Iterable<RolesCursor> {
    private static final String GRAIN_NAME = "celesta";

    private static final String OBJECT_NAME = "roles";

    public static final String TABLE_NAME = OBJECT_NAME;

    public final RolesCursor.Columns COLUMNS;

    private String id;

    private String description;

    {
        this.COLUMNS = new RolesCursor.Columns(callContext().getCelesta());
    }

    public RolesCursor(CallContext context) {
        super(context);
    }

    public RolesCursor(CallContext context, ColumnMeta<?>... columns) {
        super(context, columns);
    }

    public String getId() {
        return this.id;
    }

    public RolesCursor setId(String id) {
        this.id = id;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public RolesCursor setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    protected Object _getFieldValue(String name) {
        switch (name) {
            case "id": return this.id;
            case "description": return this.description;
            default: return null;
        }
    }

    @Override
    protected void _setFieldValue(String name, Object value) {
        switch (name) {
            case "id": {
                this.id = (String) value;
                break;
            }
            case "description": {
                this.description = (String) value;
                break;
            }
            default:;
        }
    }

    @Override
    protected Object[] _currentKeyValues() {
        return new Object[] {id};
    }

    public boolean tryGet(String id) {
        return tryGetByValuesArray(id);
    }

    public void get(String id) {
        getByValuesArray(id);
    }

    @Override
    protected void _parseResultInternal(ResultSet rs) throws SQLException {
        if (this.inRec("id")) {
            this.id = rs.getString("id");
            if (rs.wasNull()) {
                this.id = null;
            }
        }
        if (this.inRec("description")) {
            this.description = rs.getString("description");
            if (rs.wasNull()) {
                this.description = null;
            }
        }
        this.setRecversion(rs.getInt("recversion"));
    }

    @Override
    public void _clearBuffer(boolean withKeys) {
        if (withKeys) {
            this.id = null;
        }
        this.description = null;
    }

    @Override
    public Object[] _currentValues() {
        return new Object[] {id, description};
    }

    @Override
    protected void _setAutoIncrement(int val) {
    }

    public static void onPreDelete(ICelesta celesta, Consumer<? super RolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_DELETE, RolesCursor.class, cursorConsumer);
    }

    public static void onPostDelete(ICelesta celesta,
            Consumer<? super RolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_DELETE, RolesCursor.class, cursorConsumer);
    }

    public static void onPreInsert(ICelesta celesta, Consumer<? super RolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_INSERT, RolesCursor.class, cursorConsumer);
    }

    public static void onPostInsert(ICelesta celesta,
            Consumer<? super RolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_INSERT, RolesCursor.class, cursorConsumer);
    }

    public static void onPreUpdate(ICelesta celesta, Consumer<? super RolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.PRE_UPDATE, RolesCursor.class, cursorConsumer);
    }

    public static void onPostUpdate(ICelesta celesta,
            Consumer<? super RolesCursor> cursorConsumer) {
        celesta.getTriggerDispatcher().registerTrigger(TriggerType.POST_UPDATE, RolesCursor.class, cursorConsumer);
    }

    @Override
    public RolesCursor _getBufferCopy(CallContext context,
            Collection<? extends ColumnMeta<?>> fields) {
        final RolesCursor result;
        if (Objects.isNull(fields)) {
            result = new RolesCursor(context);
        }
        else {
            result = new RolesCursor(context, fields.toArray(new ColumnMeta<?>[0]));
        }
        result.copyFieldsFrom(this);
        return result;
    }

    @Override
    public void copyFieldsFrom(BasicCursor c) {
        RolesCursor from = (RolesCursor)c;
        this.id = from.id;
        this.description = from.description;
        this.setRecversion(from.getRecversion());
    }

    @Override
    public Iterator<RolesCursor> iterator() {
        return new CursorIterator<RolesCursor>(this);
    }

    @Override
    protected String _grainName() {
        return GRAIN_NAME;
    }

    @Override
    protected String _objectName() {
        return OBJECT_NAME;
    }

    @SuppressWarnings("unchecked")
    @Generated(
            value = "ru.curs.celesta.plugin.maven.CursorGenerator",
            date = "2025-05-12T14:12:45.7518922"
    )
    @CelestaGenerated
    public static final class Columns {
        private final Table element;

        public Columns(ICelesta celesta) {
            this.element = celesta.getScore().getGrains().get(GRAIN_NAME).getElements(Table.class).get(OBJECT_NAME);
        }

        public ColumnMeta<String> id() {
            return (ColumnMeta<String>) this.element.getColumns().get("id");
        }

        public ColumnMeta<String> description() {
            return (ColumnMeta<String>) this.element.getColumns().get("description");
        }
    }
}
