/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.test;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.ConnectionPoolConfiguration;
import ru.curs.celesta.DBType;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.dbutils.DbUpdater;
import ru.curs.celesta.dbutils.DbUpdaterImpl;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.configuration.DbAdaptorFactory;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlConsumer;
import ru.curs.celesta.dbutils.adaptors.ddl.JdbcDdlConsumer;
import ru.curs.celesta.score.AbstractScore;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.Score;
import ru.curs.celesta.score.discovery.ScoreByScorePathDiscovery;
import ru.curs.celesta.score.discovery.ScoreDiscovery;
import ru.curs.celesta.test.ContainerUtils;
import ru.curs.celesta.test.ScorePath;
import ru.curs.celesta.test.common.AdvancedFireBirdContainer;
import ru.curs.celesta.test.common.CollatedMSSQLServerContainer;
import ru.curs.celesta.test.mock.CelestaImpl;

public final class DbUpdaterExtension
implements TestTemplateInvocationContextProvider,
BeforeAllCallback,
AfterAllCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbUpdaterExtension.class);
    private static final List<DBType> supportedDbTypes;
    private final EnumMap<DBType, JdbcDatabaseContainer<?>> containers = new EnumMap(DBType.class);
    private final EnumMap<DBType, DBAdaptor> dbAdaptors = new EnumMap(DBType.class);
    private final Map<DBType, ConnectionPool> connectionPools = new HashMap<DBType, ConnectionPool>();

    public boolean supportsTestTemplate(ExtensionContext extensionContext) {
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        return supportedDbTypes.stream().map(this::invocationContext);
    }

    private TestTemplateInvocationContext invocationContext(final DBType dbType) {
        return new TestTemplateInvocationContext(){

            public String getDisplayName(int invocationIndex) {
                return dbType.name();
            }

            public List<Extension> getAdditionalExtensions() {
                return Collections.singletonList(new ParameterResolver(){

                    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
                        return parameterContext.getParameter().getType().equals(DbUpdater.class);
                    }

                    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
                        ScorePath scorePath = parameterContext.getParameter().getAnnotation(ScorePath.class);
                        return DbUpdaterExtension.this.createDbUpdater(dbType, scorePath.value());
                    }
                });
            }
        };
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.startDbs();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.clearDbs();
    }

    private void startDbs() {
        String emptyScorePath = "src/test/resources/emptyScore";
        PostgreSQLContainer postgreSQLContainer = ContainerUtils.POSTGRE_SQL;
        postgreSQLContainer.start();
        this.containers.put(DBType.POSTGRESQL, (JdbcDatabaseContainer<?>)postgreSQLContainer);
        OracleContainer oracleContainer = ContainerUtils.ORACLE;
        oracleContainer.start();
        this.containers.put(DBType.ORACLE, (JdbcDatabaseContainer<?>)oracleContainer);
        CollatedMSSQLServerContainer mssqlServerContainer = ContainerUtils.MSSQL;
        mssqlServerContainer.start();
        this.containers.put(DBType.MSSQL, (JdbcDatabaseContainer<?>)mssqlServerContainer);
        AdvancedFireBirdContainer firebirdContainer = ContainerUtils.FIREBIRD;
        firebirdContainer.start();
        this.containers.put(DBType.FIREBIRD, (JdbcDatabaseContainer<?>)firebirdContainer);
        supportedDbTypes.forEach(dbType -> {
            ConnectionPool connectionPool = this.createConnectionPool((DBType)dbType, this.containers.get(dbType));
            DBAdaptor dbAdaptor = new DbAdaptorFactory().setDbType(dbType).setDdlConsumer((DdlConsumer)new JdbcDdlConsumer()).setConnectionPool(connectionPool).createDbAdaptor();
            this.dbAdaptors.put((DBType)dbType, dbAdaptor);
            this.connectionPools.put((DBType)dbType, connectionPool);
            this.createDbUpdater((DBType)dbType, "src/test/resources/emptyScore").updateSystemSchema();
        });
    }

    private void clearDbs() {
        try {
            this.connectionPools.get(DBType.H2).get().createStatement().execute("SHUTDOWN");
        }
        catch (SQLException ex) {
            LOGGER.error("Error on shutting down DB", (Throwable)ex);
        }
        this.containers.forEach((b, c) -> {
            this.connectionPools.get(b).close();
            ContainerUtils.cleanUp(c);
        });
    }

    private ConnectionPool createConnectionPool(DBType dbType, JdbcDatabaseContainer<?> container) {
        ConnectionPoolConfiguration connectionPoolConfiguration = new ConnectionPoolConfiguration();
        String jdbcUrl = Optional.ofNullable(container).map(c -> c.getJdbcUrl().replace("localhost", "0.0.0.0")).orElse("jdbc:h2:mem:celesta;DB_CLOSE_DELAY=-1");
        String login = Optional.ofNullable(container).map(JdbcDatabaseContainer::getUsername).orElse("");
        String password = Optional.ofNullable(container).map(JdbcDatabaseContainer::getPassword).orElse("");
        connectionPoolConfiguration.setJdbcConnectionUrl(jdbcUrl);
        connectionPoolConfiguration.setLogin(login);
        connectionPoolConfiguration.setPassword(password);
        connectionPoolConfiguration.setDriverClassName(dbType.getDriverClassName());
        return ConnectionPool.create((ConnectionPoolConfiguration)connectionPoolConfiguration);
    }

    private DbUpdater<?> createDbUpdater(DBType dbType, String scorePath) {
        Score score;
        try {
            score = (Score)new AbstractScore.ScoreBuilder(Score.class).scoreDiscovery((ScoreDiscovery)new ScoreByScorePathDiscovery(scorePath)).build();
        }
        catch (ParseException e) {
            throw new CelestaException((Throwable)e);
        }
        DBAdaptor dbAdaptor = this.dbAdaptors.get(dbType);
        ConnectionPool connectionPool = this.connectionPools.get(dbType);
        connectionPool.setDbAdaptor(dbAdaptor);
        CelestaImpl celesta = new CelestaImpl(dbAdaptor, connectionPool, score);
        return new DbUpdaterImpl(connectionPool, score, true, dbAdaptor, (ICelesta)celesta);
    }

    static {
        Locale.setDefault(Locale.US);
        supportedDbTypes = Arrays.stream(DBType.values()).filter(dbType -> !DBType.UNKNOWN.equals(dbType)).collect(Collectors.toList());
    }
}

