/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.test.common;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TimeZone;
import org.testcontainers.containers.MSSQLServerContainer;

public class CollatedMSSQLServerContainer<SELF extends CollatedMSSQLServerContainer<SELF>>
extends MSSQLServerContainer<SELF> {
    public static final String DATABASE_NAME = "celesta";
    private String collation;
    private boolean isCustomDbCreated;

    public SELF withCollation(String collation) {
        this.collation = collation;
        return (SELF)((Object)((CollatedMSSQLServerContainer)this.self()));
    }

    public void start() {
        super.start();
        if (this.collation != null) {
            this.createCustomDataBase();
        }
    }

    protected void configure() {
        super.configure();
        this.addEnv("SET_CONTAINER_TIMEZONE", "true");
        this.addEnv("TZ", TimeZone.getDefault().getID());
    }

    private void createCustomDataBase() {
        this.isCustomDbCreated = false;
        try (Connection conn = this.createConnection("");
             Statement stmt = conn.createStatement();){
            StringBuilder sqlBuilder = new StringBuilder("CREATE DATABASE ").append(DATABASE_NAME);
            if (this.collation != null) {
                sqlBuilder.append(" COLLATE " + this.collation);
            }
            stmt.executeUpdate(sqlBuilder.toString());
            conn.commit();
            this.isCustomDbCreated = true;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getJdbcUrl() {
        StringBuilder sb = new StringBuilder(this.getInitJdbcUrl());
        if (this.isCustomDbCreated) {
            sb.append(";databaseName=").append(DATABASE_NAME);
        }
        return sb.toString();
    }

    public String getInitJdbcUrl() {
        return "jdbc:sqlserver://" + this.getContainerIpAddress() + ":" + this.getMappedPort(MS_SQL_SERVER_PORT);
    }
}

