/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.lyra.kernel.BasicLyraForm;
import ru.curs.lyra.kernel.LyraFormData;

public abstract class BasicCardForm<T extends BasicCursor>
extends BasicLyraForm<T> {
    private static final String UTF_8 = "utf-8";
    private LyraFormData lfd;

    public BasicCardForm(CallContext context) {
        super(context);
    }

    public String findRec() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.serialize((BasicCursor)this.rec(), result);
        try {
            return result.toString(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public synchronized String revert(String data) {
        Cursor c = this.getCursor();
        try {
            ByteArrayInputStream dataIS = new ByteArrayInputStream(data.getBytes(UTF_8));
            this.deserialize(c, dataIS);
            c.navigate("=<>");
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            this.serialize((BasicCursor)c, result);
            return result.toString(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public synchronized String move(String cmd, String data) {
        try {
            Object rec = this.rec();
            if (rec instanceof Cursor) {
                Cursor c = (Cursor)rec;
                ByteArrayInputStream dataIS = new ByteArrayInputStream(data.getBytes(UTF_8));
                this.deserialize(c, dataIS);
                if (!c.tryUpdate()) {
                    c.insert();
                }
            }
            rec.navigate(cmd);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            this.serialize((BasicCursor)this.rec(), result);
            return result.toString(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public synchronized String newRec() {
        Cursor c = this.getCursor();
        c.clear();
        c.setRecversion(0);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.serialize((BasicCursor)c, result);
        try {
            return result.toString(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public synchronized String deleteRec(String data) {
        Cursor c = this.getCursor();
        try {
            ByteArrayInputStream dataIS = new ByteArrayInputStream(data.getBytes(UTF_8));
            this.deserialize(c, dataIS);
            c.delete();
            if (!c.navigate(">+")) {
                c.clear();
                c.setRecversion(0);
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            this.serialize((BasicCursor)c, result);
            return result.toString(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    void serialize(BasicCursor c, OutputStream result) {
        this.beforeSending(c);
        this.lfd = new LyraFormData(c, this.getFieldsMeta(), this.getId());
        this.lfd.serialize(result);
    }

    void deserialize(Cursor c, InputStream dataIS) {
        this.lfd = new LyraFormData(dataIS);
        this.lfd.populateFields(c, this.getFieldsMeta());
        this.afterReceiving(c);
    }

    public abstract void afterReceiving(Cursor var1);
}

