/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.lyra.kernel.BasicLyraForm;
import ru.curs.lyra.kernel.LyraFormData;
import ru.curs.lyra.kernel.LyraFormField;
import ru.curs.lyra.kernel.grid.GridDriver;

public abstract class BasicGridForm<T extends BasicCursor>
extends BasicLyraForm<T> {
    private static final int DEFAULT_GRID_HEIGHT = 50;
    private GridDriver gd;
    private final LinkedList<BasicCursor> savedPositions = new LinkedList();

    public BasicGridForm(CallContext context) {
        super(context);
        this.actuateGridDriver((BasicCursor)this.getCursor(context));
    }

    private void actuateGridDriver(BasicCursor c) {
        if (this.gd == null) {
            this.gd = new GridDriver(c);
        } else if (!this.gd.isValidFor(c)) {
            Runnable notifier = this.gd.getChangeNotifier();
            int maxExactScrollValue = this.gd.getMaxExactScrollValue();
            this.gd = new GridDriver(c);
            this.gd.setChangeNotifier(notifier);
            this.gd.setMaxExactScrollValue(maxExactScrollValue);
        }
    }

    public <T> T externalAction(ExternalAction<T> f, T fallBack) {
        CallContext context = this.getContext();
        if (context == null) {
            return fallBack;
        }
        boolean closeContext = context.isClosed();
        if (closeContext) {
            this.setCallContext(context.getCopy());
        }
        try {
            T t = f.call((BasicCursor)this.rec());
            return t;
        }
        catch (CelestaException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CelestaException("Error %s while retrieving grid rows: %s", new Object[]{e.getClass().getName(), e.getMessage()});
        }
        finally {
            if (closeContext) {
                this.getContext().close();
            }
        }
    }

    public synchronized List<LyraFormData> getRows(int position) {
        return this.getRowsH(position, this.getGridHeight());
    }

    public synchronized List<LyraFormData> getRowsH(int position, int h) {
        return this.externalAction(c -> {
            this.actuateGridDriver(c);
            if (this.gd.setPosition(position, c)) {
                return this.returnRows(c, h);
            }
            return Collections.emptyList();
        }, Collections.emptyList());
    }

    public synchronized List<LyraFormData> getRows() {
        return this.getRowsH(this.getGridHeight());
    }

    public synchronized List<LyraFormData> getRowsH(int h) {
        return this.externalAction(bc -> {
            if (bc.navigate("=<-")) {
                this.gd.setPosition(bc);
                return this.returnRows(bc, h);
            }
            return Collections.emptyList();
        }, Collections.emptyList());
    }

    public synchronized List<LyraFormData> setPosition(Object ... pk) {
        return this.setPositionH(this.getGridHeight(), pk);
    }

    public synchronized List<LyraFormData> setPositionH(int h, Object ... pk) {
        return this.externalAction(bc -> {
            this.actuateGridDriver(bc);
            if (bc instanceof Cursor) {
                Cursor c = (Cursor)bc;
                if (c.meta().getPrimaryKey().size() != pk.length) {
                    throw new CelestaException("Invalid number of 'setPosition' arguments for '%s': expected %d, provided %d.", new Object[]{c.meta().getName(), c.meta().getPrimaryKey().size(), pk.length});
                }
                int i = 0;
                for (String name : c.meta().getPrimaryKey().keySet()) {
                    c.setValue(name, pk[i++]);
                }
            } else {
                bc.setValue((String)bc.meta().getColumns().keySet().iterator().next(), pk[0]);
            }
            if (bc.navigate("=<-")) {
                this.gd.setPosition(bc);
                return this.returnRows(bc, h);
            }
            return Collections.emptyList();
        }, Collections.emptyList());
    }

    private List<LyraFormData> returnRows(BasicCursor c, int h) {
        LyraFormData lfd;
        int i;
        String id = this.getId();
        ArrayList<LyraFormData> result = new ArrayList<LyraFormData>(h);
        Map<String, LyraFormField> meta = this.getFieldsMeta();
        BasicCursor copy = c._getBufferCopy((CallContext)c.callContext(), null);
        copy.close();
        for (i = 0; i < h; ++i) {
            this.beforeSending(c);
            lfd = new LyraFormData(c, meta, id);
            result.add(lfd);
            if (!c.next()) break;
        }
        c.copyFieldsFrom(copy);
        if (result.size() < h) {
            for (i = result.size(); i < h && c.previous(); ++i) {
                this.beforeSending(c);
                lfd = new LyraFormData(c, meta, id);
                result.add(0, lfd);
            }
            c.copyFieldsFrom(copy);
        }
        return result;
    }

    public void setChangeNotifier(Runnable callback) {
        this.gd.setChangeNotifier(callback);
    }

    public Runnable getChangeNotifier() {
        return this.gd.getChangeNotifier();
    }

    public void setMaxExactScrollValue(int val) {
        this.gd.setMaxExactScrollValue(val);
    }

    public int getMaxExactScrollValue() {
        return this.gd.getMaxExactScrollValue();
    }

    public int getApproxTotalCount() {
        return this.gd.getApproxTotalCount();
    }

    public int getTopVisiblePosition() {
        return this.gd.getTopVisiblePosition();
    }

    public void saveCursorPosition() {
        this.externalAction(c -> {
            BasicCursor copy = c._getBufferCopy(this.getContext(), null);
            copy.close();
            this.savedPositions.push(copy);
            return null;
        }, null);
    }

    public void restoreCursorPosition() {
        this.externalAction(c -> {
            BasicCursor copy = this.savedPositions.pop();
            this.rec().copyFieldsFrom(copy);
            return null;
        }, null);
    }

    public int getGridHeight() {
        return 50;
    }

    public Map<String, String> getSummaryRow() {
        return null;
    }

    @FunctionalInterface
    public static interface ExternalAction<T> {
        public T call(BasicCursor var1);
    }
}

