/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.lyra.kernel.FieldAccessor;
import ru.curs.lyra.kernel.LyraFieldType;

final class FieldAccessorFactory {
    private FieldAccessorFactory() {
    }

    static FieldAccessor create(int index, String name, LyraFieldType lft) {
        switch (lft) {
            case DATETIME: {
                return new BasicBoundFieldAccessor(index, name){
                    private SimpleDateFormat sdf;

                    @Override
                    public void setValue(BasicCursor c, Object val, String buf) {
                        if (val instanceof Date) {
                            c.setValue(this.name(), val);
                        } else {
                            Date d;
                            if (this.sdf == null) {
                                this.sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                            }
                            try {
                                d = this.sdf.parse(buf);
                            }
                            catch (ParseException e) {
                                d = null;
                            }
                            c.setValue(this.name(), (Object)d);
                        }
                    }
                };
            }
            case BIT: {
                return new BasicBoundFieldAccessor(index, name){

                    @Override
                    public void setValue(BasicCursor c, Object val, String buf) {
                        c.setValue(this.name(), (Object)Boolean.valueOf(buf));
                    }
                };
            }
            case INT: {
                return new BasicBoundFieldAccessor(index, name){

                    @Override
                    public void setValue(BasicCursor c, Object val, String buf) {
                        c.setValue(this.name(), (Object)Integer.valueOf(buf));
                    }
                };
            }
            case REAL: {
                return new BasicBoundFieldAccessor(index, name){

                    @Override
                    public void setValue(BasicCursor c, Object val, String buf) {
                        c.setValue(this.name(), (Object)Double.valueOf(buf));
                    }
                };
            }
        }
        return new BasicBoundFieldAccessor(index, name){

            @Override
            public void setValue(BasicCursor c, Object val, String buf) {
                c.setValue(this.name(), (Object)buf);
            }
        };
    }

    private static abstract class BasicBoundFieldAccessor
    implements FieldAccessor {
        private final int index;
        private final String name;

        BasicBoundFieldAccessor(int index, String name) {
            this.index = index;
            this.name = name;
        }

        @Override
        public final Object getValue(Object[] c) {
            return c[this.index];
        }

        @Override
        public final void setValue(BasicCursor c, Object newValue) {
            if (newValue == null) {
                c.setValue(this.name, null);
            } else {
                String buf = newValue.toString();
                this.setValue(c, newValue, buf);
            }
        }

        final String name() {
            return this.name;
        }

        abstract void setValue(BasicCursor var1, Object var2, String var3);
    }
}

