/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.curs.lyra.kernel.LyraFormField;
import ru.curs.lyra.kernel.LyraNamedElement;

public final class LyraFieldValue
extends LyraNamedElement {
    static final String XML_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private final Object val;
    private final LyraFormField lff;

    LyraFieldValue(LyraFormField lff, Object val) {
        super(lff.getName());
        this.lff = lff;
        this.val = val;
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartElement(this.getName());
        xmlWriter.writeAttribute("type", this.lff.getType().toString());
        if (this.lff.getCssClassName() != null) {
            xmlWriter.writeAttribute("cssClassName", this.lff.getCssClassName());
        }
        if (this.lff.getCssStyle() != null) {
            xmlWriter.writeAttribute("cssStyle", this.lff.getCssStyle());
        }
        xmlWriter.writeAttribute("dateFormat", Integer.toString(this.lff.getDateFormat()));
        if (this.lff.getDecimalSeparator() != null) {
            xmlWriter.writeAttribute("decimalSeparator", this.lff.getDecimalSeparator());
        }
        if (this.lff.getGroupingSeparator() != null) {
            xmlWriter.writeAttribute("groupingSeparator", this.lff.getGroupingSeparator());
        }
        if (this.val == null) {
            xmlWriter.writeAttribute("null", Boolean.toString(true));
        }
        if (this.lff.getScale() != 2) {
            xmlWriter.writeAttribute("scale", Integer.toString(this.lff.getScale()));
        }
        if (this.lff.isRequired()) {
            xmlWriter.writeAttribute("required", Boolean.toString(true));
        }
        if (this.val instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat(XML_DATE_FORMAT);
            xmlWriter.writeCharacters(sdf.format(this.val));
        } else {
            xmlWriter.writeCharacters(this.val == null ? "" : this.val.toString());
        }
        xmlWriter.writeEndElement();
    }

    public Object getValue() {
        return this.val;
    }

    public LyraFormField meta() {
        return this.lff;
    }
}

