/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.lyra.kernel.LyraFieldType;
import ru.curs.lyra.kernel.LyraFieldValue;
import ru.curs.lyra.kernel.LyraFormField;
import ru.curs.lyra.kernel.LyraNamedElementHolder;

public final class LyraFormData {
    private final LyraNamedElementHolder<LyraFieldValue> fields = new LyraNamedElementHolder<LyraFieldValue>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected String getErrorMsg(String name) {
            return "Field " + name + " is defined more than once in form data";
        }
    };
    private int recversion;
    private Object[] keyValues;
    private String formId;
    private SimpleDateFormat sdf;

    public LyraFormData(BasicCursor c, Map<String, LyraFormField> map, String formId) {
        if (c instanceof Cursor) {
            this.recversion = ((Cursor)c).getRecversion();
            this.keyValues = ((Cursor)c).getCurrentKeyValues();
        } else {
            this.keyValues = new Object[1];
            this.keyValues[0] = c._currentValues()[0];
        }
        this.formId = formId;
        Object[] vals = c._currentValues();
        for (LyraFormField lff : map.values()) {
            Object val = lff.getAccessor().getValue(vals);
            LyraFieldValue lfv = new LyraFieldValue(lff, val);
            this.fields.addElement(lfv);
        }
    }

    public LyraFormData(InputStream is) {
        FormDataParser parser = new FormDataParser();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new StreamSource(is), new SAXResult(parser));
        }
        catch (Exception e) {
            throw new CelestaException("XML deserialization error: %s", new Object[]{e.getMessage()});
        }
    }

    public Collection<LyraFieldValue> getFields() {
        return this.fields;
    }

    public void populateFields(Cursor c, Map<String, LyraFormField> map) {
        c.setRecversion(this.recversion);
        for (LyraFieldValue lfv : this.fields) {
            LyraFormField lff = map.get(lfv.getName());
            if (lff == null) continue;
            lff.getAccessor().setValue((BasicCursor)c, lfv.getValue());
        }
    }

    public void serialize(OutputStream outputStream) {
        try {
            XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            xmlWriter.writeStartDocument();
            xmlWriter.writeStartElement("schema");
            xmlWriter.writeAttribute("recversion", Integer.toString(this.recversion));
            if (this.formId != null) {
                xmlWriter.writeAttribute("formId", this.formId);
            }
            Iterator<LyraFieldValue> i = this.fields.iterator();
            while (i.hasNext()) {
                i.next().serialize(xmlWriter);
            }
            xmlWriter.writeEndDocument();
            xmlWriter.flush();
        }
        catch (Exception e) {
            throw new CelestaException("XML Serialization error: %s", new Object[]{e.getMessage()});
        }
    }

    public int getRecversion() {
        return this.recversion;
    }

    public Object[] getKeyValues() {
        return this.keyValues;
    }

    private final class FormDataParser
    extends DefaultHandler {
        private final StringBuilder sb = new StringBuilder();
        private String key;
        private int status = 0;
        private boolean isNull = false;
        private LyraFieldType type = null;
        private int scale;
        private boolean required = false;
        private String cssClassName;
        private String cssStyle;
        private int dateFormat = 3;
        private String decimalSeparator = ",";
        private String groupingSeparator = " ";

        private FormDataParser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            switch (this.status) {
                case 0: {
                    LyraFormData.this.recversion = Integer.parseInt(attributes.getValue("recversion"));
                    LyraFormData.this.formId = attributes.getValue("formId");
                    this.status = 1;
                    break;
                }
                case 1: {
                    this.key = localName;
                    this.type = LyraFieldType.valueOf(attributes.getValue("type"));
                    String buf = attributes.getValue("null");
                    this.isNull = buf == null ? false : Boolean.parseBoolean(buf);
                    buf = attributes.getValue("scale");
                    this.scale = buf == null ? 2 : Integer.parseInt(buf);
                    buf = attributes.getValue("required");
                    this.required = buf == null ? false : Boolean.parseBoolean(buf);
                    this.cssClassName = buf = attributes.getValue("cssClassName");
                    this.cssStyle = buf = attributes.getValue("cssStyle");
                    buf = attributes.getValue("dateFormat");
                    this.dateFormat = Integer.parseInt(buf);
                    this.decimalSeparator = buf = attributes.getValue("decimalSeparator");
                    this.groupingSeparator = buf = attributes.getValue("groupingSeparator");
                    this.status = 2;
                    this.sb.setLength(0);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.status == 2) {
                this.sb.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.status == 2) {
                this.status = 1;
                try {
                    LyraFieldValue v;
                    LyraFormField lff = new LyraFormField(this.key);
                    lff.setScale(this.scale);
                    lff.setRequired(this.required);
                    lff.setType(this.type);
                    lff.setCssClassName(this.cssClassName);
                    lff.setCssStyle(this.cssStyle);
                    lff.setDateFormat(this.dateFormat);
                    lff.setDecimalSeparator(this.decimalSeparator);
                    lff.setGroupingSeparator(this.groupingSeparator);
                    if (this.isNull && this.sb.length() == 0) {
                        v = new LyraFieldValue(lff, null);
                    } else {
                        String buf = this.sb.toString();
                        switch (this.type) {
                            case DATETIME: {
                                Date d;
                                if (LyraFormData.this.sdf == null) {
                                    LyraFormData.this.sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                                }
                                try {
                                    d = LyraFormData.this.sdf.parse(buf);
                                }
                                catch (ParseException e) {
                                    d = null;
                                }
                                v = new LyraFieldValue(lff, d);
                                break;
                            }
                            case BIT: {
                                v = new LyraFieldValue(lff, Boolean.valueOf(buf));
                                break;
                            }
                            case INT: {
                                v = new LyraFieldValue(lff, Integer.valueOf(buf));
                                break;
                            }
                            case REAL: {
                                v = new LyraFieldValue(lff, Double.valueOf(buf));
                                break;
                            }
                            default: {
                                v = new LyraFieldValue(lff, buf);
                            }
                        }
                    }
                    LyraFormData.this.fields.addElement(v);
                }
                catch (CelestaException e) {
                    throw new SAXException(e.getMessage());
                }
            }
        }
    }
}

