/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel.grid;

import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.SystemCallContext;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.StaticDataAdaptor;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.ViewColumnMeta;
import ru.curs.lyra.kernel.grid.BitFieldEnumerator;
import ru.curs.lyra.kernel.grid.CompositeKeyEnumerator;
import ru.curs.lyra.kernel.grid.DateFieldEnumerator;
import ru.curs.lyra.kernel.grid.IntFieldEnumerator;
import ru.curs.lyra.kernel.grid.InterpolationInitializer;
import ru.curs.lyra.kernel.grid.KeyEnumerator;
import ru.curs.lyra.kernel.grid.KeyInterpolator;
import ru.curs.lyra.kernel.grid.NullableFieldEnumerator;
import ru.curs.lyra.kernel.grid.RequestTask;
import ru.curs.lyra.kernel.grid.VarcharFieldEnumerator;

public final class GridDriver {
    public static final int DEFAULT_SMALL_SCROLL = 120;
    public static final int DEFAULT_COUNT = 1024;
    private final KeyInterpolator interpolator;
    private final InterpolationInitializer interpolationInitializer;
    private final KeyEnumerator rootKeyEnumerator;
    private final Map<String, KeyEnumerator> keyEnumerators = new HashMap<String, KeyEnumerator>();
    private Runnable changeNotifier;
    private CounterThread counterThread = null;
    private BigInteger latestRequest;
    private BigInteger topVisiblePosition;
    private RequestTask task;
    private final BasicCursor closedCopy;
    private int smallScroll = 120;

    public GridDriver(BasicCursor c, Runnable callback) {
        this(c);
        this.setChangeNotifier(callback);
    }

    public GridDriver(BasicCursor c) {
        this.closedCopy = c._getBufferCopy((CallContext)c.callContext(), null);
        this.closedCopy.copyFiltersFrom(c);
        this.closedCopy.copyOrderFrom(c);
        this.closedCopy.close();
        boolean[] descOrders = c.descOrders();
        boolean desc = descOrders[0];
        for (int i = 1; i < descOrders.length; ++i) {
            if (desc == descOrders[i]) continue;
            throw new CelestaException("Mixed ASC/DESC ordering for grid: %s", new Object[]{c.getOrderBy()});
        }
        DataGrainElement meta = c.meta();
        String[] quotedNames = c.orderByColumnNames();
        String[] names = new String[quotedNames.length];
        for (int i = 0; i < quotedNames.length; ++i) {
            names[i] = quotedNames[i].substring(1, quotedNames[i].length() - 1);
        }
        DBAdaptor dbAdaptor = ((CallContext)c.callContext()).getDbAdaptor();
        if (names.length == 1) {
            ColumnMeta m = (ColumnMeta)meta.getColumns().get(names[0]);
            this.rootKeyEnumerator = this.createKeyEnumerator(m, dbAdaptor.nullsFirst(), dbAdaptor);
            this.keyEnumerators.put(names[0], this.rootKeyEnumerator);
        } else {
            KeyEnumerator[] km = new KeyEnumerator[names.length];
            for (int i = 0; i < names.length; ++i) {
                ColumnMeta m = (ColumnMeta)meta.getColumns().get(names[i]);
                km[i] = this.createKeyEnumerator(m, dbAdaptor.nullsFirst(), dbAdaptor);
                this.keyEnumerators.put(names[i], km[i]);
            }
            this.rootKeyEnumerator = new CompositeKeyEnumerator(km);
        }
        if (c.navigate("+")) {
            BigInteger higherOrd = this.getCursorOrdinal(c);
            c.navigate("-");
            BigInteger lowerOrd = this.getCursorOrdinal(c);
            this.interpolator = new KeyInterpolator(lowerOrd, higherOrd, 1024, desc);
            this.topVisiblePosition = lowerOrd;
            this.requestRefinement(higherOrd, true);
        } else {
            this.interpolator = new KeyInterpolator(BigInteger.ZERO, BigInteger.ZERO, 0, desc);
            this.topVisiblePosition = BigInteger.ZERO;
        }
        this.interpolationInitializer = new InterpolationInitializer(this.interpolator, dbAdaptor){

            @Override
            void setCursorOrdinal(BasicCursor c, BigInteger key) {
                GridDriver.this.setCursorOrdinal(c, key);
            }

            @Override
            BigInteger getCursorOrdinal(BasicCursor c) {
                return GridDriver.this.getCursorOrdinal(c);
            }
        };
    }

    public boolean isValidFor(BasicCursor c) {
        return this.closedCopy.isEquivalent(c);
    }

    public boolean setPosition(int position, BasicCursor c) {
        BigInteger key;
        this.checkMeta(c);
        int closestPosition = this.interpolator.getClosestPosition(position);
        int absDelta = Math.abs(position - closestPosition);
        if (absDelta < this.smallScroll && (key = this.interpolator.getExactPoint(closestPosition)) != null) {
            this.setCursorOrdinal(c, key);
            if (c.navigate("=")) {
                String cmd = position > closestPosition ? ">" : "<";
                for (int i = 0; i < absDelta; ++i) {
                    c.navigate(cmd);
                }
                BigInteger ord = this.getCursorOrdinal(c);
                this.interpolator.setPoint(ord, position);
                this.topVisiblePosition = ord;
                return true;
            }
        }
        key = this.interpolator.getPoint(position);
        this.setCursorOrdinal(c, key);
        if (c.navigate("=>+")) {
            this.topVisiblePosition = this.getCursorOrdinal(c);
            this.requestRefinement(this.topVisiblePosition, false);
            return true;
        }
        c._clearBuffer(true);
        this.topVisiblePosition = BigInteger.ZERO;
        this.interpolator.resetToEmptyTable();
        return false;
    }

    public void setPosition(BasicCursor c) {
        this.checkMeta(c);
        this.topVisiblePosition = this.getCursorOrdinal(c);
        this.requestRefinement(this.topVisiblePosition, false);
    }

    private void requestRefinement(BigInteger key, boolean immediate) {
        if (key.equals(this.latestRequest)) {
            return;
        }
        this.latestRequest = key;
        this.task = new RequestTask(key, immediate);
        if (this.counterThread == null || !this.counterThread.isAlive()) {
            this.counterThread = new CounterThread();
            this.counterThread.start();
        }
    }

    synchronized BigInteger getCursorOrdinal(BasicCursor c) {
        return this.getCursorOrdinal(c, this.closedCopy.meta().getColumns().keySet());
    }

    synchronized BigInteger getCursorOrdinal(BasicCursor c, Collection<String> fields) {
        int i = 0;
        Object[] values = c._currentValues();
        for (String cname : fields) {
            KeyEnumerator km = this.keyEnumerators.get(cname);
            if (km != null) {
                km.setValue(values[i]);
            }
            ++i;
        }
        return this.rootKeyEnumerator.getOrderValue();
    }

    synchronized void setCursorOrdinal(BasicCursor c, BigInteger key) {
        this.rootKeyEnumerator.setOrderValue(key);
        for (Map.Entry<String, KeyEnumerator> e : this.keyEnumerators.entrySet()) {
            c.setValue(e.getKey(), e.getValue().getValue());
        }
    }

    public int getTopVisiblePosition() {
        return this.interpolator.getApproximatePosition(this.topVisiblePosition);
    }

    private KeyEnumerator createKeyEnumerator(ColumnMeta m, boolean nullsFirst, DBAdaptor dbAdaptor) {
        KeyEnumerator result;
        String celestaType = m.getCelestaType();
        if ("BIT".equals(celestaType)) {
            result = new BitFieldEnumerator();
        } else if ("INT".equals(celestaType)) {
            result = new IntFieldEnumerator();
        } else if ("VARCHAR".equals(celestaType)) {
            int length;
            if (m instanceof StringColumn) {
                StringColumn s = (StringColumn)m;
                length = s.getLength();
            } else {
                ViewColumnMeta vcm = (ViewColumnMeta)m;
                if (vcm.getLength() < 0) {
                    throw new CelestaException("Undefined length for VARCHAR view field: cannot use it as a key field in a grid.");
                }
                length = vcm.getLength();
            }
            result = new VarcharFieldEnumerator((StaticDataAdaptor)dbAdaptor, length);
        } else if ("DATETIME".equals(celestaType)) {
            result = new DateFieldEnumerator();
        } else {
            throw new CelestaException("The field with type '%s' cannot be used as a key field in a grid.", new Object[]{celestaType});
        }
        if (m.isNullable()) {
            result = NullableFieldEnumerator.create(nullsFirst, result);
        }
        return result;
    }

    private void checkMeta(BasicCursor c) {
        if (c.meta() != this.closedCopy.meta()) {
            throw new CelestaException("Metaobjects for cursor and cursor position specifier don't match.");
        }
    }

    public int getApproxTotalCount() {
        return this.interpolator.getApproximateCount();
    }

    public void setChangeNotifier(Runnable changeNotifier) {
        this.changeNotifier = changeNotifier;
    }

    public Runnable getChangeNotifier() {
        return this.changeNotifier;
    }

    public void setMaxExactScrollValue(int smallScroll) {
        this.smallScroll = smallScroll;
    }

    public int getMaxExactScrollValue() {
        return this.smallScroll;
    }

    static /* synthetic */ BasicCursor access$000(GridDriver x0) {
        return x0.closedCopy;
    }

    static /* synthetic */ RequestTask access$100(GridDriver x0) {
        return x0.task;
    }

    static /* synthetic */ KeyInterpolator access$200(GridDriver x0) {
        return x0.interpolator;
    }

    static /* synthetic */ InterpolationInitializer access$300(GridDriver x0) {
        return x0.interpolationInitializer;
    }

    static /* synthetic */ RequestTask access$102(GridDriver x0, RequestTask x1) {
        x0.task = x1;
        return x0.task;
    }

    static /* synthetic */ Runnable access$400(GridDriver x0) {
        return x0.changeNotifier;
    }

    static /* synthetic */ CounterThread access$502(GridDriver x0, CounterThread x1) {
        x0.counterThread = x1;
        return x0.counterThread;
    }

    private final class CounterThread
    extends Thread {
        private CounterThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            closedCopyCallContext = (CallContext)GridDriver.access$000(GridDriver.this).callContext();
            try {
                sysContext = new SystemCallContext(closedCopyCallContext.getCelesta(), "LyraCounterThread");
                var3_4 = null;
                columns = Arrays.stream(GridDriver.access$000(GridDriver.this).orderByColumnNames()).map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, unquot(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).collect(Collectors.toList());
                c = GridDriver.access$000(GridDriver.this)._getBufferCopy((CallContext)sysContext, columns);
                c.copyFiltersFrom(GridDriver.access$000(GridDriver.this));
                c.copyOrderFrom(GridDriver.access$000(GridDriver.this));
lbl10:
                // 4 sources

                while (true) {
                    if ((myRequest = GridDriver.access$100(GridDriver.this)) != null) ** GOTO lbl40
                    count = GridDriver.access$200(GridDriver.this).getApproximateCount();
                    if (GridDriver.access$300(GridDriver.this).initialize(c, count)) continue;
                    if (sysContext == null) return;
                    if (var3_4 != null) {
                    }
                    ** GOTO lbl38
                    break;
                }
                {
                    catch (Throwable var4_6) {
                        var3_4 = var4_6;
                        throw var4_6;
                    }
                    catch (Throwable var10_13) {
                        if (sysContext == null) throw var10_13;
                        if (var3_4 == null) {
                            sysContext.close();
                            throw var10_13;
                        }
                        try {
                            sysContext.close();
                            throw var10_13;
                        }
                        catch (Throwable var11_14) {
                            var3_4.addSuppressed(var11_14);
                            throw var10_13;
                        }
                    }
                    try {
                        sysContext.close();
                        return;
                    }
                    catch (Throwable var8_12) {
                        var3_4.addSuppressed(var8_12);
                        return;
                    }
lbl38:
                    // 1 sources

                    sysContext.close();
                    return;
lbl40:
                    // 1 sources

                    ** try [egrp 4[TRYBLOCK] [8, 9 : 191->328)] { 
lbl-1000:
                    // 1 sources

                    {
                        block18: {
                            delta = myRequest.getDelayBeforeRun();
                            if (delta <= 0L) break block18;
                            Thread.sleep(delta);
                            ** GOTO lbl10
                        }
                        GridDriver.access$102(GridDriver.this, null);
                        GridDriver.this.setCursorOrdinal(c, myRequest.getKey());
                        result = c.position();
                        GridDriver.access$200(GridDriver.this).setPoint(myRequest.getKey(), result);
                        if (GridDriver.access$400(GridDriver.this) == null) ** GOTO lbl10
                        GridDriver.access$400(GridDriver.this).run();
                        ** continue;
                    }
                }
            }
lbl54:
            // 4 sources

            catch (InterruptedException | CelestaException e) {
                return;
            }
            finally {
                GridDriver.access$502(GridDriver.this, null);
            }
        }
    }
}

