/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel.grid;

import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class KeyEnumerator {
    private static final int MAX_BIT_LENGTH = 1022;

    public abstract BigInteger cardinality();

    public abstract BigInteger getOrderValue();

    public abstract void setOrderValue(BigInteger var1);

    public abstract void setValue(Object var1);

    public abstract Object getValue();

    public double getPosition() {
        BigInteger order = this.getOrderValue();
        BigInteger maxOrder = this.cardinality().subtract(BigInteger.ONE);
        if (order.equals(BigInteger.ZERO)) {
            return 0.0;
        }
        if (order.equals(maxOrder)) {
            return 1.0;
        }
        BigInteger gcd = order.gcd(maxOrder);
        order = order.divide(gcd);
        int blex = (maxOrder = maxOrder.divide(gcd)).bitLength() - 1022;
        if (blex > 0) {
            order = order.shiftRight(blex);
            maxOrder = maxOrder.shiftRight(blex);
        }
        return order.doubleValue() / maxOrder.doubleValue();
    }

    public void setPosition(double p) {
        if (p < 0.0) {
            throw new IllegalArgumentException();
        }
        if (p == 0.0) {
            this.setOrderValue(BigInteger.ZERO);
        } else if (p < 1.0) {
            BigDecimal c = new BigDecimal(this.cardinality(), 0);
            c = c.multiply(BigDecimal.valueOf(p));
            this.setOrderValue(c.toBigInteger());
        } else if (p == 1.0) {
            this.setOrderValue(this.cardinality().subtract(BigInteger.ONE));
        } else {
            throw new IllegalArgumentException();
        }
    }
}

