/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.ReflectionUtils;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.lyra.dto.FormInstantiationParams;
import ru.curs.lyra.kernel.BasicGridForm;
import ru.curs.lyra.kernel.annotations.FormParams;
import ru.curs.lyra.service.LyraGridScrollBack;
import ru.curs.lyra.service.LyraService;

public class FormFactory {
    private final Map<String, BasicGridForm<? extends BasicCursor>> forms = new HashMap<String, BasicGridForm<? extends BasicCursor>>();

    BasicGridForm<? extends BasicCursor> getFormInstance(CallContext callContext, FormInstantiationParams parameters, LyraService srv) {
        BasicGridForm form = this.forms.computeIfAbsent(parameters.getDgridId(), key -> this.getBasicGridFormInstance(callContext, parameters, srv));
        form.setCallContext(callContext);
        return this.setParameters(form, parameters);
    }

    void clearForms() {
        this.forms.clear();
    }

    private BasicGridForm<? extends BasicCursor> setParameters(BasicGridForm<? extends BasicCursor> form, FormInstantiationParams parameters) {
        ReflectionUtils.doWithLocalFields(form.getClass(), field -> {
            if (field.isAnnotationPresent(FormParams.class) && field.getType() == FormInstantiationParams.class) {
                field.setAccessible(true);
                ReflectionUtils.setField((Field)field, (Object)form, (Object)parameters);
            }
        });
        return form;
    }

    private BasicGridForm<? extends BasicCursor> getBasicGridFormInstance(CallContext callContext, FormInstantiationParams parameters, LyraService srv) {
        try {
            Object instance;
            Class<?> clazz = Class.forName(parameters.getFormClass());
            try {
                Constructor<?> constructor = clazz.getConstructor(CallContext.class, FormInstantiationParams.class);
                instance = constructor.newInstance(callContext, parameters);
            }
            catch (NoSuchMethodException e) {
                Constructor<?> constructor = clazz.getConstructor(CallContext.class);
                instance = constructor.newInstance(callContext);
            }
            BasicGridForm form = (BasicGridForm)instance;
            LyraGridScrollBack scrollBack = new LyraGridScrollBack(srv, parameters.getDgridId());
            scrollBack.setBasicGridForm(form);
            form.setChangeNotifier(scrollBack);
            return this.setParameters(form, parameters);
        }
        catch (Exception e) {
            throw new CelestaException((Throwable)e);
        }
    }
}

