/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.service;

import java.time.LocalDateTime;
import ru.curs.lyra.dto.LyraGridAddInfo;
import ru.curs.lyra.dto.ScrollBackParams;
import ru.curs.lyra.kernel.BasicGridForm;
import ru.curs.lyra.service.LyraService;

public final class LyraGridScrollBack
implements Runnable {
    static final int DGRID_MAX_TOTALCOUNT = 50000;
    static final int DGRID_SMALLSTEP = 100;
    private static final int LYRA_SMALLFACTOR = 100;
    private final LyraService srv;
    private String dgridId;
    private BasicGridForm basicGridForm;
    private LyraGridAddInfo lyraGridAddInfo = new LyraGridAddInfo();

    LyraGridScrollBack(LyraService srv, String dGridId) {
        this.srv = srv;
        this.dgridId = dGridId;
    }

    LyraGridAddInfo getLyraGridAddInfo() {
        return this.lyraGridAddInfo;
    }

    void setLyraGridAddInfo(LyraGridAddInfo aLyraGridAddInfo) {
        this.lyraGridAddInfo = aLyraGridAddInfo;
    }

    BasicGridForm getBasicGridForm() {
        return this.basicGridForm;
    }

    void setBasicGridForm(BasicGridForm aBasicGridForm) {
        this.basicGridForm = aBasicGridForm;
    }

    @Override
    public void run() {
        int dgridNewPosition;
        System.out.println("LyraGridScrollBack.ddddddddddddd2");
        System.out.println("className: " + this.basicGridForm.getClass().getSimpleName());
        System.out.println("date: " + LocalDateTime.now());
        System.out.println("lyraOldPosition: " + this.lyraGridAddInfo.getLyraOldPosition());
        System.out.println("lyraNewPosition: " + this.basicGridForm.getTopVisiblePosition());
        System.out.println("diff: " + (this.basicGridForm.getTopVisiblePosition() - this.lyraGridAddInfo.getLyraOldPosition()));
        System.out.println("getApproxTotalCount: " + this.basicGridForm.getApproxTotalCount());
        int lyraApproxTotalCount = this.basicGridForm.getApproxTotalCount();
        if (lyraApproxTotalCount == 0) {
            return;
        }
        if (Math.abs(this.basicGridForm.getTopVisiblePosition() - this.lyraGridAddInfo.getLyraOldPosition()) <= lyraApproxTotalCount / 100 || this.basicGridForm.getApproxTotalCount() < this.basicGridForm.getGridHeight() * 2) {
            this.lyraGridAddInfo.setLyraOldPosition(this.basicGridForm.getTopVisiblePosition());
            return;
        }
        if (lyraApproxTotalCount <= 50000) {
            dgridNewPosition = this.basicGridForm.getTopVisiblePosition();
        } else {
            double d = this.basicGridForm.getTopVisiblePosition();
            d = d / (double)lyraApproxTotalCount * (double)this.lyraGridAddInfo.getDgridOldTotalCount();
            dgridNewPosition = (int)d;
        }
        this.lyraGridAddInfo.setLyraOldPosition(this.basicGridForm.getTopVisiblePosition());
        this.srv.sendScrollBackPosition(new ScrollBackParams(this.dgridId, dgridNewPosition));
    }
}

