/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.lyra.kernel.BasicLyraForm;
import ru.curs.lyra.kernel.LyraFormData;

public abstract class BasicCardForm<T extends BasicCursor>
extends BasicLyraForm<T> {
    private static final String UTF_8 = "utf-8";
    private LyraFormData lfd;

    public BasicCardForm(CallContext context) {
        super(context);
    }

    public String findRec(CallContext ctx) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.serialize((BasicCursor)this.rec(ctx), result);
        try {
            return result.toString(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public synchronized String revert(CallContext ctx, String data) {
        Cursor c = this.getRecCursor(ctx);
        try {
            ByteArrayInputStream dataIS = new ByteArrayInputStream(data.getBytes(UTF_8));
            this.deserialize(c, dataIS);
            c.navigate("=<>");
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            this.serialize((BasicCursor)c, result);
            return result.toString(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public synchronized String move(CallContext ctx, String cmd, String data) {
        try {
            Object rec = this.rec(ctx);
            if (rec instanceof Cursor) {
                Cursor c = (Cursor)rec;
                ByteArrayInputStream dataIS = new ByteArrayInputStream(data.getBytes(UTF_8));
                this.deserialize(c, dataIS);
                if (!c.tryUpdate()) {
                    c.insert();
                }
            }
            rec.navigate(cmd);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            this.serialize((BasicCursor)this.rec(ctx), result);
            return result.toString(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public synchronized String newRec(CallContext ctx) {
        Cursor c = this.getRecCursor(ctx);
        c.clear();
        c.setRecversion(0);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.serialize((BasicCursor)c, result);
        try {
            return result.toString(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public synchronized String deleteRec(CallContext ctx, String data) {
        Cursor c = this.getRecCursor(ctx);
        try {
            ByteArrayInputStream dataIS = new ByteArrayInputStream(data.getBytes(UTF_8));
            this.deserialize(c, dataIS);
            c.delete();
            if (!c.navigate(">+")) {
                c.clear();
                c.setRecversion(0);
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            this.serialize((BasicCursor)c, result);
            return result.toString(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    private Cursor getRecCursor(CallContext ctx) {
        Object rec = this.rec(ctx);
        if (rec instanceof Cursor) {
            return (Cursor)rec;
        }
        throw new CelestaException("Cursor %s is not modifiable.", new Object[]{rec.meta().getName()});
    }

    void serialize(BasicCursor c, OutputStream result) {
        this.beforeSending(c);
        this.lfd = new LyraFormData(c, this.getFieldsMeta(), this.getId());
        this.lfd.serialize(result);
    }

    void deserialize(Cursor c, InputStream dataIS) {
        this.lfd = new LyraFormData(dataIS);
        this.lfd.populateFields(c, this.getFieldsMeta());
        this.afterReceiving(c);
    }

    public abstract void afterReceiving(Cursor var1);
}

