/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.lyra.kernel.BasicLyraForm;
import ru.curs.lyra.kernel.GridRefinementHandler;
import ru.curs.lyra.kernel.LyraFormData;
import ru.curs.lyra.kernel.LyraFormField;
import ru.curs.lyra.kernel.grid.GridDriver;

public abstract class BasicGridForm<T extends BasicCursor>
extends BasicLyraForm<T> {
    private static final int DEFAULT_GRID_HEIGHT = 50;
    private GridDriver gd;
    private final LinkedList<BasicCursor> savedPositions = new LinkedList();
    private final GridRefinementHandler changeNotifier;
    private final Runnable driverNotifier;

    public BasicGridForm(CallContext context, GridRefinementHandler changeNotifier) {
        super(context);
        this.changeNotifier = changeNotifier;
        this.driverNotifier = changeNotifier == null ? null : () -> changeNotifier.accept(this);
        this.actuateGridDriver((BasicCursor)this.getCursor(context));
    }

    private void actuateGridDriver(BasicCursor c) {
        if (this.gd == null) {
            this.gd = new GridDriver(c, this.driverNotifier);
        } else if (!this.gd.isValidFor(c)) {
            int maxExactScrollValue = this.gd.getMaxExactScrollValue();
            this.gd = new GridDriver(c, this.driverNotifier);
            this.gd.setMaxExactScrollValue(maxExactScrollValue);
        }
    }

    public List<LyraFormData> getRows(CallContext ctx, int position) {
        return this.getRowsH(ctx, position, this.getGridHeight());
    }

    public synchronized List<LyraFormData> getRowsH(CallContext ctx, int position, int h) {
        Object c = this.rec(ctx);
        this.actuateGridDriver((BasicCursor)c);
        if (this.gd.setPosition(position, (BasicCursor)c)) {
            return this.returnRows((BasicCursor)c, h);
        }
        return Collections.emptyList();
    }

    public synchronized List<LyraFormData> getRows(CallContext ctx) {
        return this.getRowsH(ctx, this.getGridHeight());
    }

    public synchronized List<LyraFormData> getRowsH(CallContext ctx, int h) {
        String cmd;
        Object bc = this.rec(ctx);
        String string = cmd = Arrays.stream(bc._currentValues()).anyMatch(Objects::nonNull) ? "=<-" : "-";
        if (bc.navigate(cmd)) {
            this.gd.setPosition((BasicCursor)bc);
            return this.returnRows((BasicCursor)bc, h);
        }
        this.gd.truncate();
        return Collections.emptyList();
    }

    public synchronized List<LyraFormData> setPosition(CallContext ctx, Object ... pk) {
        return this.setPositionH(ctx, this.getGridHeight(), pk);
    }

    public synchronized List<LyraFormData> setPositionH(CallContext ctx, int h, Object ... pk) {
        Object bc = this.rec(ctx);
        this.actuateGridDriver((BasicCursor)bc);
        if (bc instanceof Cursor) {
            Cursor c = (Cursor)bc;
            if (c.meta().getPrimaryKey().size() != pk.length) {
                throw new CelestaException("Invalid number of 'setPosition' arguments for '%s': expected %d, provided %d.", new Object[]{c.meta().getName(), c.meta().getPrimaryKey().size(), pk.length});
            }
            int i = 0;
            for (String name : c.meta().getPrimaryKey().keySet()) {
                c.setValue(name, pk[i++]);
            }
        } else {
            bc.setValue((String)bc.meta().getColumns().keySet().iterator().next(), pk[0]);
        }
        if (bc.navigate("=<-")) {
            this.gd.setPosition((BasicCursor)bc);
            return this.returnRows((BasicCursor)bc, h);
        }
        return Collections.emptyList();
    }

    private List<LyraFormData> returnRows(BasicCursor c, int h) {
        LyraFormData lfd;
        int i;
        String id = this.getId();
        ArrayList<LyraFormData> result = new ArrayList<LyraFormData>(h);
        Map<String, LyraFormField> meta = this.getFieldsMeta();
        BasicCursor copy = c._getBufferCopy((CallContext)c.callContext(), null);
        copy.close();
        for (i = 0; i < h; ++i) {
            this.beforeSending(c);
            lfd = new LyraFormData(c, meta, id);
            result.add(lfd);
            if (!c.next()) break;
        }
        c.copyFieldsFrom(copy);
        if (result.size() < h) {
            for (i = result.size(); i < h && c.previous(); ++i) {
                this.beforeSending(c);
                lfd = new LyraFormData(c, meta, id);
                result.add(0, lfd);
            }
            c.copyFieldsFrom(copy);
        }
        return result;
    }

    public GridRefinementHandler getChangeNotifier() {
        return this.changeNotifier;
    }

    public void setMaxExactScrollValue(int val) {
        this.gd.setMaxExactScrollValue(val);
    }

    public int getMaxExactScrollValue() {
        return this.gd.getMaxExactScrollValue();
    }

    public int getApproxTotalCount() {
        return this.gd.getApproxTotalCount();
    }

    public int getTopVisiblePosition() {
        return this.gd.getTopVisiblePosition();
    }

    public void saveCursorPosition(CallContext ctx) {
        Object c = this.rec(ctx);
        BasicCursor copy = c._getBufferCopy(ctx, null);
        copy.close();
        this.savedPositions.push(copy);
    }

    public void restoreCursorPosition(CallContext ctx) {
        BasicCursor copy = this.savedPositions.pop();
        this.rec(ctx).copyFieldsFrom(copy);
    }

    public int getGridHeight() {
        return 50;
    }

    public Map<String, String> getSummaryRow() {
        return null;
    }
}

