/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.util.ReflectionUtils;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.score.CelestaDocUtils;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.FloatingColumn;
import ru.curs.celesta.score.GrainElement;
import ru.curs.celesta.score.StringColumn;
import ru.curs.lyra.kernel.FieldAccessor;
import ru.curs.lyra.kernel.FieldAccessorFactory;
import ru.curs.lyra.kernel.LyraFieldType;
import ru.curs.lyra.kernel.LyraFormField;
import ru.curs.lyra.kernel.LyraFormProperties;
import ru.curs.lyra.kernel.LyraNamedElement;
import ru.curs.lyra.kernel.LyraNamedElementHolder;
import ru.curs.lyra.kernel.UnboundFieldAccessor;
import ru.curs.lyra.kernel.annotations.FormField;
import ru.curs.lyra.kernel.annotations.LyraForm;

public abstract class BasicLyraForm<T extends BasicCursor> {
    public static final String PROPERTIES = "recordProperties";
    private static final Pattern FIELD_NAME_PATTERN = Pattern.compile("^(is|get)([A-Z])([^$]*$)");
    private final DataGrainElement meta;
    private final LyraNamedElementHolder<LyraFormField> fieldsMeta = new LyraNamedElementHolder<LyraFormField>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected String getErrorMsg(String name) {
            return String.format("Field '%s' defined more than once in a form.", name);
        }
    };
    private T rec;
    LyraFormProperties lyraFormProperties = new LyraFormProperties();

    public BasicLyraForm(CallContext context) {
        LyraForm lyraForm = this.getClass().getAnnotation(LyraForm.class);
        if (lyraForm != null) {
            this.lyraFormProperties.setGridwidth(lyraForm.gridWidth()).setGridheight(lyraForm.gridHeight()).setHeader(lyraForm.gridHeader()).setFooter(lyraForm.gridFooter()).setVisibleColumnsHeader(lyraForm.visibleColumnsHeader()).setAllowTextSelection(lyraForm.allowTextSelection());
        }
        this.createUnboundField(this.fieldsMeta, PROPERTIES);
        this.rec = this.getCursor(context);
        this.rec.navigate("-");
        this.meta = this.rec.meta();
    }

    BasicLyraForm(DataGrainElement m) {
        this.meta = m;
    }

    public void createAllBoundFields() {
        int i = 0;
        for (Map.Entry e : this.meta.getColumns().entrySet()) {
            this.createBoundField((String)e.getKey(), i++, (ColumnMeta)e.getValue());
        }
    }

    public void createAllUnboundFields() {
        this.createAllUnboundFields(this.fieldsMeta);
    }

    private static boolean getPropertyVal(JSONObject metadata, String propName, boolean def) throws JSONException {
        return metadata.has(propName) ? metadata.getBoolean(propName) : def;
    }

    private LyraFormField createBoundField(String name, int index, ColumnMeta m) {
        LyraFieldType lft = LyraFieldType.lookupFieldType(m);
        FieldAccessor a = FieldAccessorFactory.create(index, name, lft);
        LyraFormField f = new LyraFormField(name, a);
        this.fieldsMeta.addElement(f);
        f.setType(LyraFieldType.lookupFieldType(m));
        String json = CelestaDocUtils.getCelestaDocJSON((String)m.getCelestaDoc());
        try {
            JSONObject metadata = new JSONObject(json);
            f.setCaption(metadata.has("caption") ? metadata.getString("caption") : f.getName());
            f.setEditable(BasicLyraForm.getPropertyVal(metadata, "editable", true));
            f.setSortable(BasicLyraForm.getPropertyVal(metadata, "sortable", true));
            f.setVisible(BasicLyraForm.getPropertyVal(metadata, "visible", true));
            if (metadata.has("scale")) {
                f.setScale(metadata.getInt("scale"));
            } else if (m instanceof StringColumn && !((StringColumn)m).isMax()) {
                StringColumn sc = (StringColumn)m;
                f.setScale(sc.getLength());
            } else if (m instanceof FloatingColumn) {
                f.setScale(2);
            } else {
                f.setScale(2);
            }
            if (m instanceof Column) {
                boolean dbRequired = !m.isNullable();
                f.setRequired(metadata.has("required") ? metadata.getBoolean("required") | dbRequired : dbRequired);
            } else {
                f.setRequired(BasicLyraForm.getPropertyVal(metadata, "required", false));
            }
            f.setCssClassName(metadata.has("cssClassName") ? metadata.getString("cssClassName") : null);
            f.setCssStyle(metadata.has("cssStyle") ? metadata.getString("cssStyle") : null);
            f.setDateFormat(metadata.has("dateFormat") ? metadata.getString("dateFormat") : "dd.MM.yyyy");
            f.setDecimalSeparator(metadata.has("decimalSeparator") ? metadata.getString("decimalSeparator") : ",");
            f.setGroupingSeparator(metadata.has("groupingSeparator") ? metadata.getString("groupingSeparator") : " ");
        }
        catch (JSONException e1) {
            throw new CelestaException("JSON Error: %s", new Object[]{e1.getMessage()});
        }
        return f;
    }

    public LyraFormField createField(String name) {
        String n;
        ColumnMeta m = (ColumnMeta)this.meta.getColumns().get(name);
        if (m == null) {
            LyraFormField result = this.createUnboundField(this.fieldsMeta, name);
            if (result == null) {
                throw new CelestaException(String.format("Column '%s' not found in '%s.%s'", name, this.meta.getGrain().getName(), this.meta.getName()));
            }
            return result;
        }
        int index = 0;
        Iterator iterator = this.meta.getColumns().keySet().iterator();
        while (iterator.hasNext() && !(n = (String)iterator.next()).equals(name)) {
            ++index;
        }
        return this.createBoundField(name, index, m);
    }

    public synchronized T rec(CallContext ctx) {
        if (this.rec == null) {
            this.rec = this.getCursor(ctx);
            this.rec.navigate("-");
        } else if (this.rec.callContext() != ctx) {
            T rec2 = this.getCursor(ctx);
            rec2.copyFieldsFrom(this.rec);
            this.rec = rec2;
            this.rec.navigate("=>+");
        }
        return this.rec;
    }

    public Map<String, LyraFormField> getFieldsMeta() {
        return this.fieldsMeta.getElements();
    }

    public GrainElement meta() {
        return this.meta;
    }

    public String[] orderByColumnNames() {
        return this.rec == null ? null : this.rec.orderByColumnNames();
    }

    public boolean[] descOrders() {
        return this.rec == null ? null : this.rec.descOrders();
    }

    public abstract T getCursor(CallContext var1);

    public String getId() {
        return this.getClass().getName();
    }

    public LyraFormProperties getFormProperties() {
        return this.lyraFormProperties;
    }

    private static boolean isGetter(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0 || parameterTypes.length == 1 && parameterTypes[0].equals(CallContext.class)) {
            if (method.getName().matches("^get[A-Z].*") && !method.getReturnType().equals(Void.TYPE)) {
                return true;
            }
            if (method.getName().matches("^is[A-Z].*") && method.getReturnType().equals(Boolean.TYPE)) {
                return true;
            }
        }
        return false;
    }

    private String extractFieldName(Method m) {
        Matcher matcher = FIELD_NAME_PATTERN.matcher(m.getName());
        matcher.matches();
        return matcher.group(2).toLowerCase() + matcher.group(3);
    }

    protected LyraFormField createUnboundField(LyraNamedElementHolder<LyraFormField> meta, String name) {
        List<LyraFormField> newFields = this.getUnboundFields(method -> name.equals(this.extractFieldName((Method)method)));
        if (newFields.size() == 0) {
            if (PROPERTIES.equals(name)) {
                return null;
            }
            throw new CelestaException("Field '%s' has no annotated getters", new Object[]{name});
        }
        if (newFields.size() > 1) {
            String getterNames = newFields.stream().map(LyraNamedElement::getName).collect(Collectors.joining(","));
            throw new CelestaException("Field '%s' has too many annotated getters: %s", new Object[]{name, getterNames});
        }
        LyraFormField newField = newFields.get(0);
        meta.addElement(newField);
        return newField;
    }

    private List<LyraFormField> getUnboundFields(Predicate<Method> filter) {
        ArrayList<LyraFormField> newFields = new ArrayList<LyraFormField>();
        ReflectionUtils.doWithLocalMethods(this.getClass(), getter -> {
            if (BasicLyraForm.isGetter(getter) && getter.isAnnotationPresent(FormField.class) && filter.test(getter)) {
                UnboundFieldAccessor ufa = new UnboundFieldAccessor(getter, null, this);
                LyraFormField f = new LyraFormField(this.extractFieldName(getter), ufa);
                newFields.add(f);
                FormField formField = getter.getAnnotation(FormField.class);
                LyraFieldType lyraFieldType = LyraFieldType.lookupFieldType(getter.getReturnType());
                if (formField != null) {
                    f.setCaption(formField.caption()).setVisible(formField.visible()).setEditable(formField.editable()).setSortable(formField.sortable()).setRequired(formField.required()).setScale(formField.scale()).setType(lyraFieldType).setLookup(formField.lookup()).setCssClassName(formField.cssClassName()).setCssStyle(formField.cssStyle()).setDateFormat(formField.dateFormat()).setDecimalSeparator(formField.decimalSeparator()).setGroupingSeparator(formField.groupingSeparator());
                }
            }
        });
        return newFields;
    }

    protected void createAllUnboundFields(LyraNamedElementHolder<LyraFormField> fieldsMeta) {
        List<LyraFormField> unboundFields = this.getUnboundFields(m -> true);
        for (LyraFormField field : unboundFields) {
            fieldsMeta.addElement(field);
        }
    }

    public void beforeSending(BasicCursor c) {
    }
}

