/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel;

import java.util.Date;
import java.util.HashMap;
import ru.curs.celesta.dbutils.BLOB;
import ru.curs.celesta.score.ColumnMeta;

public enum LyraFieldType {
    BLOB,
    BIT,
    DATETIME,
    REAL,
    INT,
    VARCHAR;

    private static final HashMap<String, LyraFieldType> C2L;
    private static final HashMap<Class<?>, LyraFieldType> J2L;

    public static LyraFieldType lookupFieldType(ColumnMeta c) {
        LyraFieldType result = C2L.get(c.getCelestaType());
        if (result == null) {
            throw new RuntimeException(String.format("Invalid table column type: %s", c.getClass().toString()));
        }
        return result;
    }

    public static LyraFieldType lookupFieldType(Class<?> clazz) {
        return J2L.get(clazz);
    }

    static {
        C2L = new HashMap();
        J2L = new HashMap();
        C2L.put("INT", INT);
        C2L.put("VARCHAR", VARCHAR);
        C2L.put("TEXT", VARCHAR);
        C2L.put("REAL", REAL);
        C2L.put("DATETIME", DATETIME);
        C2L.put("BIT", BIT);
        C2L.put("BLOB", BLOB);
        J2L.put(Boolean.TYPE, BIT);
        J2L.put(Integer.TYPE, INT);
        J2L.put(BLOB.class, BLOB);
        J2L.put(Date.class, DATETIME);
        J2L.put(String.class, VARCHAR);
        J2L.put(Double.TYPE, REAL);
    }
}

