/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.curs.celesta.CelestaException;

public abstract class LyraNamedElement {
    private static final int MAX_IDENTIFIER_LENGTH = 30;
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_]*");
    private final String name;

    public LyraNamedElement(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        LyraNamedElement.validateIdentifier(name);
        this.name = name;
    }

    static void validateIdentifier(String name) {
        Matcher m = NAME_PATTERN.matcher(name);
        if (!m.matches()) {
            throw new CelestaException("Invalid identifier: '" + name + "'.");
        }
        if (name.length() > 30) {
            throw new CelestaException("Identifier '" + name + "' is longer than " + 30 + " characters.");
        }
    }

    public final String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LyraNamedElement that = (LyraNamedElement)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

