/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import ru.curs.celesta.CelestaException;
import ru.curs.lyra.kernel.LyraNamedElement;

public abstract class LyraNamedElementHolder<T extends LyraNamedElement>
implements Collection<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, T> namespace = new LinkedHashMap<String, T>();
    private final transient Map<String, T> namespaceReadOnly = Collections.unmodifiableMap(this.namespace);

    public Map<String, T> getElements() {
        return this.namespaceReadOnly;
    }

    protected abstract String getErrorMsg(String var1);

    public final void addElement(T element) {
        LyraNamedElement oldValue = (LyraNamedElement)this.namespace.put(((LyraNamedElement)element).getName(), element);
        if (oldValue != null) {
            this.namespace.put(oldValue.getName(), oldValue);
            throw new CelestaException(this.getErrorMsg(((LyraNamedElement)element).getName()));
        }
    }

    public final T get(String name) {
        return (T)((LyraNamedElement)this.namespace.get(name));
    }

    @Override
    public final boolean isEmpty() {
        return this.namespace.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.namespace.values().iterator();
    }

    @Override
    public int size() {
        return this.namespace.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.namespace.containsValue(o);
    }

    @Override
    public Object[] toArray() {
        return this.namespace.values().toArray();
    }

    @Override
    public <A> A[] toArray(A[] a) {
        return this.namespace.values().toArray(a);
    }

    @Override
    @Deprecated
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof LyraNamedElement) {
            LyraNamedElement e = (LyraNamedElement)o;
            return this.namespace.remove(e.getName()) != null;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.namespace.clear();
    }
}

