/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel;

import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class RefinementTask
implements Delayed {
    private static final AtomicLong SEQUENCER = new AtomicLong();
    private static final long MILLION = 1000000L;
    private final long time;
    private final BigInteger key;
    private final long sequenceNumber;
    private final boolean immediate;

    public RefinementTask(BigInteger key, long delayMs) {
        this.immediate = delayMs <= 0L;
        this.time = this.now() + delayMs * 1000000L;
        this.sequenceNumber = SEQUENCER.getAndIncrement();
        this.key = key;
    }

    private long now() {
        return System.nanoTime();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.time - this.now(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof RefinementTask) {
            RefinementTask x = (RefinementTask)other;
            long diff = this.time - x.time;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            if (this.sequenceNumber < x.sequenceNumber) {
                return -1;
            }
            return 1;
        }
        long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public BigInteger getKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefinementTask that = (RefinementTask)o;
        return this.time == that.time && this.sequenceNumber == that.sequenceNumber && this.immediate == that.immediate && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.time, this.key, this.sequenceNumber, this.immediate);
    }
}

