/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.lyra.kernel.BasicLyraForm;
import ru.curs.lyra.kernel.FieldAccessor;

final class UnboundFieldAccessor
implements FieldAccessor {
    private Method getter;
    private Method setter;
    BasicLyraForm basicLyraForm;

    UnboundFieldAccessor(Method getter, Method setter, BasicLyraForm basicLyraForm) {
        this.getter = getter;
        this.setter = setter;
        this.basicLyraForm = basicLyraForm;
    }

    @Override
    public Object getValue(BasicCursor c) {
        Object value;
        try {
            this.getter.setAccessible(true);
            value = this.getter.getParameterCount() == 0 ? this.getter.invoke((Object)this.basicLyraForm, new Object[0]) : this.getter.invoke((Object)this.basicLyraForm, c.callContext());
        }
        catch (IllegalAccessException e) {
            throw new CelestaException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            cause.printStackTrace();
            throw new CelestaException("Error %s while getting unbound field value: %s. See logs for details.", new Object[]{cause.getClass().getName(), cause.getMessage()});
        }
        return value;
    }

    @Override
    public void setValue(BasicCursor c, Object newValue) {
        try {
            this.setter.invoke((Object)this.basicLyraForm, newValue);
        }
        catch (Throwable e) {
            throw new CelestaException("Error %s while getting unbound field value: %s. See logs for details.", new Object[]{e.getClass().getName(), e.getMessage()});
        }
    }
}

