/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel.grid;

import java.math.BigInteger;
import ru.curs.lyra.kernel.grid.KeyEnumerator;

public final class BitFieldEnumerator
extends KeyEnumerator {
    private boolean value;

    @Override
    public BigInteger cardinality() {
        return BigInteger.valueOf(2L);
    }

    @Override
    public BigInteger getOrderValue() {
        if (this.value) {
            return BigInteger.ONE;
        }
        return BigInteger.ZERO;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException();
        }
        this.value = (Boolean)value;
    }

    @Override
    public double getPosition() {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public void setOrderValue(BigInteger value) {
        if (value.equals(BigInteger.ZERO)) {
            this.value = false;
        } else if (value.equals(BigInteger.ONE)) {
            this.value = true;
        } else {
            throw new IllegalArgumentException();
        }
    }
}

