/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel.grid;

import java.math.BigInteger;
import ru.curs.lyra.kernel.grid.KeyEnumerator;

public final class IntFieldEnumerator
extends KeyEnumerator {
    private long min;
    private long max;
    private BigInteger card;
    private int value;

    public IntFieldEnumerator() {
        this.setBounds(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntFieldEnumerator(int min, int max) {
        this.setBounds(min, max);
    }

    public void setBounds(int min, int max) {
        if (max <= min) {
            throw new IllegalArgumentException();
        }
        this.min = min;
        this.max = max;
        this.card = BigInteger.valueOf(this.max - this.min + 1L);
    }

    @Override
    public BigInteger cardinality() {
        return this.card;
    }

    @Override
    public BigInteger getOrderValue() {
        return BigInteger.valueOf((long)this.value - this.min);
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        this.value = (Integer)value;
    }

    @Override
    public double getPosition() {
        return (double)((long)this.value - this.min) / (double)(this.max - this.min);
    }

    @Override
    public void setOrderValue(BigInteger value) {
        this.value = value.add(BigInteger.valueOf(this.min)).intValue();
    }
}

