/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel.grid;

import java.math.BigInteger;
import java.util.concurrent.ThreadLocalRandom;
import ru.curs.celesta.DBType;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.lyra.kernel.grid.KeyInterpolator;

public abstract class InterpolationInitializer {
    private static final int MAX_REFINEMENTS_COUNT = 100;
    private static final int DEFAULT_AMOUNT_OF_INTERPOLATION_POINTS = 10;
    private int refinementsCount = 0;
    private final KeyInterpolator interpolator;
    private final DBAdaptor dbAdaptor;
    private final ThreadLocalRandom rnd = ThreadLocalRandom.current();

    public InterpolationInitializer(KeyInterpolator interpolator, DBAdaptor dbAdaptor) {
        this.interpolator = interpolator;
        this.dbAdaptor = dbAdaptor;
    }

    public boolean initialize(BasicCursor c, int count) {
        if (count == 0) {
            return false;
        }
        if (DBType.POSTGRESQL.equals((Object)this.dbAdaptor.getType())) {
            return this.initializePostgres(c, count);
        }
        return this.initializeCommon(c);
    }

    private boolean initializeCommon(BasicCursor c) {
        if (this.refinementsCount > 100) {
            return false;
        }
        ++this.refinementsCount;
        BigInteger lav = this.interpolator.getLeastAccurateValue();
        if (lav == null) {
            return false;
        }
        this.setCursorOrdinal(c, lav);
        if (this.rnd.nextBoolean()) {
            c.navigate("=>+");
        } else {
            c.navigate("=<-");
        }
        int result = c.position();
        BigInteger key = this.getCursorOrdinal(c);
        this.interpolator.setPoint(key, result);
        return true;
    }

    private boolean initializePostgres(BasicCursor c, int count) {
        int rowNumber;
        if (this.refinementsCount > 0) {
            return false;
        }
        this.refinementsCount = 1;
        int amountOfInterpolationPoints = count > 10 ? 10 : count;
        int offset = count / amountOfInterpolationPoints;
        --amountOfInterpolationPoints;
        c.first();
        for (int point = 1; point <= amountOfInterpolationPoints && (rowNumber = point * offset) != count; ++point) {
            c.navigate(">", (long)offset);
            BigInteger key = this.getCursorOrdinal(c);
            this.interpolator.setPoint(key, rowNumber);
        }
        return true;
    }

    abstract void setCursorOrdinal(BasicCursor var1, BigInteger var2);

    abstract BigInteger getCursorOrdinal(BasicCursor var1);
}

