/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel.grid;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class KeyInterpolator {
    private static final int MIN_GAP_QUOTIENT = 4;
    private static final int MIN_GAP_VALUE = 10;
    private final TreeMap<Integer, BigInteger> data = new TreeMap();
    private final boolean descending;
    private BigInteger leastAccurateValue;
    private boolean isLAVValid;

    public KeyInterpolator(BigInteger minOrd, BigInteger maxOrd, int count, boolean descending) {
        this.descending = descending;
        this.data.put(0, this.negateIfDesc(minOrd));
        if (count > 0) {
            this.data.put(count - 1, this.negateIfDesc(maxOrd));
            if (count == 1 && !minOrd.equals(maxOrd)) {
                throw new IllegalArgumentException();
            }
        } else if (count < 0) {
            throw new IllegalArgumentException();
        }
        this.isLAVValid = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoint(BigInteger ord, int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        BigInteger neword = this.negateIfDesc(ord);
        KeyInterpolator keyInterpolator = this;
        synchronized (keyInterpolator) {
            Map.Entry<Integer, BigInteger> e;
            this.isLAVValid = false;
            this.data.put(count, neword);
            int c = count;
            while ((e = this.data.lowerEntry(c)) != null && e.getValue().compareTo(neword) >= 0) {
                c = e.getKey();
                this.data.remove(c);
            }
            c = count;
            while ((e = this.data.higherEntry(c)) != null && e.getValue().compareTo(neword) <= 0) {
                c = e.getKey();
                this.data.remove(c);
            }
        }
    }

    private BigInteger negateIfDesc(BigInteger ord) {
        return ord == null ? null : (this.descending ? ord.negate() : ord);
    }

    public BigInteger getExactPoint(int count) {
        return this.negateIfDesc(this.data.get(count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClosestPosition(int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        KeyInterpolator keyInterpolator = this;
        synchronized (keyInterpolator) {
            int e0;
            if (this.data.isEmpty()) {
                throw new IllegalStateException();
            }
            Integer floor = this.data.floorKey(count);
            int n = e0 = floor == null ? this.data.firstKey().intValue() : floor.intValue();
            if (e0 == count) {
                return e0;
            }
            Integer ceiling = this.data.ceilingKey(count);
            int e1 = ceiling == null ? this.data.lastKey().intValue() : ceiling.intValue();
            return count - e0 < e1 - count ? e0 : e1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getPoint(int count) {
        Map.Entry<Integer, BigInteger> e1;
        Map.Entry<Integer, BigInteger> e0;
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        KeyInterpolator keyInterpolator = this;
        synchronized (keyInterpolator) {
            e0 = this.data.floorEntry(count);
            if (e0.getKey() == count) {
                return this.negateIfDesc(e0.getValue());
            }
            e1 = this.data.ceilingEntry(count);
            if (e1 == null) {
                return this.negateIfDesc(this.data.lastEntry().getValue());
            }
        }
        BigInteger result = e1.getValue().subtract(e0.getValue()).subtract(BigInteger.ONE).multiply(BigInteger.valueOf(count - e0.getKey() - 1));
        BigInteger delta = BigInteger.valueOf(e1.getKey() - e0.getKey() - 1);
        result = e0.getValue().add(KeyInterpolator.divideAndRound(result, delta)).add(BigInteger.ONE);
        return this.negateIfDesc(result);
    }

    private static BigInteger divideAndRound(BigInteger divident, BigInteger divisor) {
        BigInteger[] qr = divident.divideAndRemainder(divisor);
        if (qr[1].shiftLeft(1).compareTo(divisor) > 0) {
            return qr[0].add(BigInteger.ONE);
        }
        return qr[0];
    }

    public int getPointsCount() {
        return this.data.size();
    }

    public int getApproximateCount() {
        if (this.data.size() == 1 && BigInteger.ZERO.equals(this.data.get(0))) {
            return 0;
        }
        return this.data.lastEntry().getKey() + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getApproximatePosition(BigInteger key) {
        BigInteger newkey = this.negateIfDesc(key);
        int cmin = 0;
        KeyInterpolator keyInterpolator = this;
        synchronized (keyInterpolator) {
            int cmax = this.data.lastEntry().getKey();
            while (cmax > cmin) {
                Map.Entry<Integer, BigInteger> ceiling;
                int delta;
                int cmid = cmax + cmin >> 1;
                if (cmid == cmin) {
                    cmid = cmax;
                }
                if ((delta = (ceiling = this.data.ceilingEntry(cmid)).getValue().compareTo(newkey)) == 0) {
                    return ceiling.getKey();
                }
                if (delta < 0) {
                    cmin = ceiling.getKey();
                    continue;
                }
                Map.Entry<Integer, BigInteger> lower = this.data.lowerEntry(cmid);
                delta = lower.getValue().compareTo(newkey);
                if (delta == 0) {
                    return lower.getKey();
                }
                if (delta > 0) {
                    cmax = lower.getKey();
                    continue;
                }
                int d = 1 + KeyInterpolator.divideAndRound(BigInteger.valueOf(ceiling.getKey() - lower.getKey() - 1).multiply(newkey.subtract(lower.getValue()).subtract(BigInteger.ONE)), ceiling.getValue().subtract(lower.getValue()).subtract(BigInteger.ONE)).intValue();
                return lower.getKey() + d;
            }
        }
        return cmin;
    }

    public synchronized BigInteger getLeastAccurateValue() {
        if (this.isLAVValid) {
            return this.negateIfDesc(this.leastAccurateValue);
        }
        this.isLAVValid = true;
        if (this.data.size() < 2) {
            this.leastAccurateValue = null;
            return null;
        }
        int deltaMax = 0;
        int cMax = this.data.lastKey();
        int deltaMin = cMax / 4;
        if (deltaMin < 10) {
            deltaMin = 10;
        }
        Iterator<Map.Entry<Integer, BigInteger>> i = this.data.entrySet().iterator();
        Map.Entry<Integer, BigInteger> c = i.next();
        BigInteger v1 = BigInteger.ZERO;
        BigInteger v2 = BigInteger.ZERO;
        do {
            Map.Entry<Integer, BigInteger> cPrev = c;
            c = i.next();
            int d = c.getKey() - cPrev.getKey();
            if (d <= deltaMax) continue;
            cMax += deltaMax;
            deltaMax = d;
            cMax -= deltaMax;
            v1 = cPrev.getValue();
            v2 = c.getValue();
        } while (c.getKey() < cMax);
        this.leastAccurateValue = deltaMax > deltaMin ? v1.add(v2).shiftRight(1) : null;
        return this.negateIfDesc(this.leastAccurateValue);
    }

    public synchronized void resetToEmptyTable() {
        this.data.clear();
        this.data.put(0, BigInteger.ZERO);
        this.isLAVValid = false;
    }
}

