/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.service;

import java.time.LocalDateTime;
import ru.curs.lyra.dto.LyraGridAddInfo;
import ru.curs.lyra.dto.ScrollBackParams;
import ru.curs.lyra.kernel.BasicGridForm;
import ru.curs.lyra.kernel.GridRefinementHandler;
import ru.curs.lyra.service.LyraService;

public final class LyraGridScrollBack
implements GridRefinementHandler {
    static final int DGRID_MAX_TOTALCOUNT = 50000;
    static final int DGRID_SMALLSTEP = 100;
    private static final int LYRA_SMALLFACTOR = 100;
    private final LyraService srv;
    private String dgridId;
    private LyraGridAddInfo lyraGridAddInfo = new LyraGridAddInfo();

    LyraGridScrollBack(LyraService srv, String dGridId) {
        this.srv = srv;
        this.dgridId = dGridId;
    }

    LyraGridAddInfo getLyraGridAddInfo() {
        return this.lyraGridAddInfo;
    }

    void setLyraGridAddInfo(LyraGridAddInfo aLyraGridAddInfo) {
        this.lyraGridAddInfo = aLyraGridAddInfo;
    }

    @Override
    public void accept(BasicGridForm<?> basicGridForm) {
        int dgridNewPosition;
        System.out.println("LyraGridScrollBack.ddddddddddddd2");
        System.out.println("className: " + basicGridForm.getClass().getSimpleName());
        System.out.println("date: " + LocalDateTime.now());
        System.out.println("lyraOldPosition: " + this.lyraGridAddInfo.getLyraOldPosition());
        System.out.println("lyraNewPosition: " + basicGridForm.getTopVisiblePosition());
        System.out.println("diff: " + (basicGridForm.getTopVisiblePosition() - this.lyraGridAddInfo.getLyraOldPosition()));
        System.out.println("getApproxTotalCount: " + basicGridForm.getApproxTotalCount());
        int lyraApproxTotalCount = basicGridForm.getApproxTotalCount();
        if (lyraApproxTotalCount == 0) {
            return;
        }
        if (Math.abs(basicGridForm.getTopVisiblePosition() - this.lyraGridAddInfo.getLyraOldPosition()) <= lyraApproxTotalCount / 100 || basicGridForm.getApproxTotalCount() < basicGridForm.getGridHeight() * 2) {
            this.lyraGridAddInfo.setLyraOldPosition(basicGridForm.getTopVisiblePosition());
            return;
        }
        if (lyraApproxTotalCount <= 50000) {
            dgridNewPosition = basicGridForm.getTopVisiblePosition();
        } else {
            double d = basicGridForm.getTopVisiblePosition();
            d = d / (double)lyraApproxTotalCount * (double)this.lyraGridAddInfo.getDgridOldTotalCount();
            dgridNewPosition = (int)d;
        }
        this.lyraGridAddInfo.setLyraOldPosition(basicGridForm.getTopVisiblePosition());
        this.srv.sendScrollBackPosition(new ScrollBackParams(this.dgridId, dgridNewPosition));
    }
}

