/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.service;

import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.stereotype.Service;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.transaction.CelestaTransaction;
import ru.curs.lyra.dto.DataResult;
import ru.curs.lyra.dto.DataRetrievalParams;
import ru.curs.lyra.dto.FormInstantiationParams;
import ru.curs.lyra.dto.MetaDataResult;
import ru.curs.lyra.dto.ScrollBackParams;
import ru.curs.lyra.kernel.BasicGridForm;
import ru.curs.lyra.service.DataFactory;
import ru.curs.lyra.service.FormFactory;
import ru.curs.lyra.service.MetadataFactory;

@Service
public class LyraService {
    private final FormFactory formFactory = new FormFactory();
    private final MetadataFactory metadataFactory = new MetadataFactory();
    private SimpMessageSendingOperations messagingTemplate;

    public LyraService(SimpMessageSendingOperations messagingTemplate) {
        this.messagingTemplate = messagingTemplate;
    }

    void sendScrollBackPosition(ScrollBackParams params) {
        this.messagingTemplate.convertAndSend((Object)"/position", (Object)params);
    }

    @CelestaTransaction
    public MetaDataResult getMetadata(CallContext callContext, FormInstantiationParams formInstantiationParams) {
        BasicGridForm<? extends BasicCursor> basicGridForm = this.formFactory.getFormInstance(callContext, formInstantiationParams, this);
        return this.metadataFactory.buildMetadata(basicGridForm);
    }

    @CelestaTransaction
    public DataResult getData(CallContext callContext, FormInstantiationParams formInstantiationParams, DataRetrievalParams dataRetrievalParams) {
        BasicGridForm<? extends BasicCursor> basicGridForm = this.formFactory.getFormInstance(callContext, formInstantiationParams, this);
        return new DataFactory(callContext, basicGridForm, dataRetrievalParams).dataResult();
    }
}

