/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.service;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.score.Index;
import ru.curs.celesta.score.Table;
import ru.curs.lyra.dto.Column;
import ru.curs.lyra.dto.Common;
import ru.curs.lyra.dto.MetaDataResult;
import ru.curs.lyra.kernel.BasicGridForm;
import ru.curs.lyra.kernel.LyraFormField;

class MetadataFactory {
    private static final String GRID_WIDTH_DEF_VALUE = "95%";
    private static final String GRID_HEIGHT_DEF_VALUE = "400px";
    private static final String RECORDS = "RECORDS";
    private static final String CSS_LYRA_TYPE = "lyra-type-";

    MetadataFactory() {
    }

    MetaDataResult buildMetadata(BasicGridForm<? extends BasicCursor> basicGridForm) {
        MetaDataResult metadata = new MetaDataResult();
        Common common = new Common();
        common.setGridWidth(Optional.ofNullable(basicGridForm.getFormProperties().getGridwidth()).filter(s -> !s.isEmpty()).orElse(GRID_WIDTH_DEF_VALUE));
        common.setGridHeight(Optional.ofNullable(basicGridForm.getFormProperties().getGridheight()).filter(s -> !s.isEmpty()).orElse(GRID_HEIGHT_DEF_VALUE));
        common.setLimit(basicGridForm.getGridHeight());
        common.setTotalCount(basicGridForm.getApproxTotalCount());
        common.setSelectionModel(RECORDS);
        common.setVisibleColumnsHeader(basicGridForm.getFormProperties().getVisibleColumnsHeader());
        common.setAllowTextSelection(basicGridForm.getFormProperties().getAllowTextSelection());
        if (basicGridForm.meta() instanceof Table) {
            Object[] arr = ((Table)basicGridForm.meta()).getPrimaryKey().keySet().toArray();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(arr[i]);
            }
            common.setPrimaryKey(sb.toString());
        }
        common.setSummaryRow(basicGridForm.getSummaryRow());
        metadata.setCommon(common);
        ArrayList<String> lyraGridAvailableSorting = new ArrayList<String>();
        if (basicGridForm.meta() instanceof Table) {
            for (Index index : ((Table)basicGridForm.meta()).getIndices()) {
                if (index.getColumns().size() != 1) continue;
                lyraGridAvailableSorting.add((String)index.getColumns().keySet().toArray()[0]);
            }
        }
        Map<String, LyraFormField> lyraFields = basicGridForm.getFieldsMeta();
        for (LyraFormField field : lyraFields.values()) {
            if ("recordProperties".equals(field.getName())) continue;
            Column column = new Column();
            column.setId(field.getName());
            column.setCaption(field.getCaption());
            column.setVisible(field.isVisible());
            column.setSortable(field.isSortable());
            column.setCssClassName(CSS_LYRA_TYPE + field.getType().toString().toLowerCase() + Optional.ofNullable(field.getCssClassName()).map(s -> s.isEmpty() ? "" : " " + s).orElse(""));
            column.setCssStyle(field.getCssStyle());
            column.setSortingAvailable(lyraGridAvailableSorting.contains(field.getName()));
            metadata.getColumns().put(String.valueOf(metadata.getColumns().size() + 1), column);
        }
        return metadata;
    }
}

