/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel.grid;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.SystemCallContext;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.StaticDataAdaptor;
import ru.curs.celesta.dbutils.term.WhereTermsMaker;
import ru.curs.celesta.score.ColumnMeta;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.ViewColumnMeta;
import ru.curs.lyra.kernel.RefinementScheduler;
import ru.curs.lyra.kernel.RefinementTask;
import ru.curs.lyra.kernel.grid.BitFieldEnumerator;
import ru.curs.lyra.kernel.grid.CompositeKeyEnumerator;
import ru.curs.lyra.kernel.grid.DateFieldEnumerator;
import ru.curs.lyra.kernel.grid.IntFieldEnumerator;
import ru.curs.lyra.kernel.grid.InterpolationInitializer;
import ru.curs.lyra.kernel.grid.KeyEnumerator;
import ru.curs.lyra.kernel.grid.KeyInterpolator;
import ru.curs.lyra.kernel.grid.NullableFieldEnumerator;
import ru.curs.lyra.kernel.grid.VarcharFieldEnumerator;

public final class GridDriver {
    public static final int DEFAULT_SMALL_SCROLL = 120;
    public static final long REFINEMENT_DELAY_MS = 500L;
    public static final int DEFAULT_COUNT = 1024;
    private final KeyInterpolator interpolator;
    private final InterpolationInitializer interpolationInitializer;
    private final KeyEnumerator rootKeyEnumerator;
    private final Map<String, KeyEnumerator> keyEnumerators = new HashMap<String, KeyEnumerator>();
    private final Runnable changeNotifier;
    private final Counter counter = new Counter();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private BigInteger latestRequest;
    private BigInteger topVisiblePosition;
    private final BasicCursor closedCopy;
    private final List<String> columns;
    private int smallScroll = 120;

    public GridDriver(BasicCursor c, Runnable changeNotifier) {
        this.changeNotifier = changeNotifier;
        this.closedCopy = c.getBufferCopy((CallContext)c.callContext(), null);
        this.closedCopy.copyFiltersFrom(c);
        this.closedCopy.copyOrderFrom(c);
        this.closedCopy.close();
        boolean[] descOrders = c.descOrders();
        boolean desc = descOrders[0];
        for (int i = 1; i < descOrders.length; ++i) {
            if (desc == descOrders[i]) continue;
            throw new CelestaException("Mixed ASC/DESC ordering for grid: %s", new Object[]{c.getOrderBy()});
        }
        DataGrainElement meta = c.meta();
        String[] quotedNames = c.orderByColumnNames();
        String[] names = new String[quotedNames.length];
        for (int i = 0; i < quotedNames.length; ++i) {
            names[i] = quotedNames[i].substring(1, quotedNames[i].length() - 1);
        }
        DBAdaptor dbAdaptor = ((CallContext)c.callContext()).getDbAdaptor();
        if (names.length == 1) {
            ColumnMeta m = (ColumnMeta)meta.getColumns().get(names[0]);
            this.rootKeyEnumerator = this.createKeyEnumerator(m, dbAdaptor.nullsFirst(), dbAdaptor);
            this.keyEnumerators.put(names[0], this.rootKeyEnumerator);
        } else {
            KeyEnumerator[] km = new KeyEnumerator[names.length];
            for (int i = 0; i < names.length; ++i) {
                ColumnMeta m = (ColumnMeta)meta.getColumns().get(names[i]);
                km[i] = this.createKeyEnumerator(m, dbAdaptor.nullsFirst(), dbAdaptor);
                this.keyEnumerators.put(names[i], km[i]);
            }
            this.rootKeyEnumerator = new CompositeKeyEnumerator(km);
        }
        if (c.navigate("+")) {
            BigInteger higherOrd = this.getCursorOrdinal(c);
            c.navigate("-");
            BigInteger lowerOrd = this.getCursorOrdinal(c);
            this.interpolator = new KeyInterpolator(lowerOrd, higherOrd, 1024, desc);
            this.topVisiblePosition = lowerOrd;
            this.requestRefinement(higherOrd, true);
        } else {
            this.interpolator = new KeyInterpolator(BigInteger.ZERO, BigInteger.ZERO, 0, desc);
            this.topVisiblePosition = BigInteger.ZERO;
        }
        this.interpolationInitializer = new InterpolationInitializer(this.interpolator, dbAdaptor){

            @Override
            void setCursorOrdinal(BasicCursor c, BigInteger key) {
                GridDriver.this.setCursorOrdinal(c, key);
            }

            @Override
            BigInteger getCursorOrdinal(BasicCursor c) {
                return GridDriver.this.getCursorOrdinal(c);
            }
        };
        this.columns = Arrays.stream(this.closedCopy.orderByColumnNames()).map(WhereTermsMaker::unquot).collect(Collectors.toList());
        this.executorService.submit(this.counter);
    }

    public boolean isValidFor(BasicCursor c) {
        return this.closedCopy.isEquivalent(c);
    }

    public boolean setPosition(int position, BasicCursor c) {
        BigInteger key;
        this.checkMeta(c);
        int closestPosition = this.interpolator.getClosestPosition(position);
        int absDelta = Math.abs(position - closestPosition);
        if (absDelta < this.smallScroll && (key = this.interpolator.getExactPoint(closestPosition)) != null) {
            this.setCursorOrdinal(c, key);
            if (c.navigate("=")) {
                String cmd = position > closestPosition ? ">" : "<";
                for (int i = 0; i < absDelta; ++i) {
                    c.navigate(cmd);
                }
                BigInteger ord = this.getCursorOrdinal(c);
                this.interpolator.setPoint(ord, position);
                this.topVisiblePosition = ord;
                return true;
            }
        }
        key = this.interpolator.getPoint(position);
        this.setCursorOrdinal(c, key);
        if (c.navigate("=>+")) {
            this.topVisiblePosition = this.getCursorOrdinal(c);
            this.requestRefinement(this.topVisiblePosition, false);
            return true;
        }
        c.clearBuffer(true);
        this.truncate();
        return false;
    }

    public void truncate() {
        this.topVisiblePosition = BigInteger.ZERO;
        this.interpolator.resetToEmptyTable();
    }

    public void setPosition(BasicCursor c) {
        this.checkMeta(c);
        this.topVisiblePosition = this.getCursorOrdinal(c);
        this.requestRefinement(this.topVisiblePosition, false);
    }

    private void requestRefinement(BigInteger key, boolean immediate) {
        if (key.equals(this.latestRequest)) {
            return;
        }
        this.latestRequest = key;
        RefinementTask task = new RefinementTask(key, immediate ? 0L : 500L);
        this.counter.setTask(task);
    }

    synchronized BigInteger getCursorOrdinal(BasicCursor c) {
        return this.getCursorOrdinal(c, this.closedCopy.meta().getColumns().keySet());
    }

    synchronized BigInteger getCursorOrdinal(BasicCursor c, Collection<String> fields) {
        int i = 0;
        Object[] values = c.getCurrentValues();
        for (String cname : fields) {
            KeyEnumerator km = this.keyEnumerators.get(cname);
            if (km != null) {
                km.setValue(values[i]);
            }
            ++i;
        }
        return this.rootKeyEnumerator.getOrderValue();
    }

    synchronized void setCursorOrdinal(BasicCursor c, BigInteger key) {
        this.rootKeyEnumerator.setOrderValue(key);
        for (Map.Entry<String, KeyEnumerator> e : this.keyEnumerators.entrySet()) {
            c.setValue(e.getKey(), e.getValue().getValue());
        }
    }

    public int getTopVisiblePosition() {
        return this.interpolator.getApproximatePosition(this.topVisiblePosition);
    }

    private KeyEnumerator createKeyEnumerator(ColumnMeta<?> m, boolean nullsFirst, DBAdaptor dbAdaptor) {
        KeyEnumerator result;
        String celestaType = m.getCelestaType();
        if ("BIT".equals(celestaType)) {
            result = new BitFieldEnumerator();
        } else if ("INT".equals(celestaType)) {
            result = new IntFieldEnumerator();
        } else if ("VARCHAR".equals(celestaType)) {
            int length;
            if (m instanceof StringColumn) {
                StringColumn s = (StringColumn)m;
                length = s.getLength();
            } else {
                ViewColumnMeta vcm = (ViewColumnMeta)m;
                if (vcm.getLength() < 0) {
                    throw new CelestaException("Undefined length for VARCHAR view field: cannot use it as a key field in a grid.");
                }
                length = vcm.getLength();
            }
            result = new VarcharFieldEnumerator((StaticDataAdaptor)dbAdaptor, length);
        } else if ("DATETIME".equals(celestaType)) {
            result = new DateFieldEnumerator();
        } else {
            throw new CelestaException("The field with type '%s' cannot be used as a key field in a grid.", new Object[]{celestaType});
        }
        if (m.isNullable()) {
            result = NullableFieldEnumerator.create(nullsFirst, result);
        }
        return result;
    }

    private void checkMeta(BasicCursor c) {
        if (c.meta() != this.closedCopy.meta()) {
            throw new CelestaException("Metaobjects for cursor and cursor position specifier don't match.");
        }
    }

    public int getApproxTotalCount() {
        return this.interpolator.getApproximateCount();
    }

    public Runnable getChangeNotifier() {
        return this.changeNotifier;
    }

    public void setMaxExactScrollValue(int smallScroll) {
        this.smallScroll = smallScroll;
    }

    public int getMaxExactScrollValue() {
        return this.smallScroll;
    }

    private final class Counter
    extends RefinementScheduler {
        private BasicCursor c;

        private Counter() {
        }

        @Override
        protected boolean refineInterpolator() {
            int count = GridDriver.this.interpolator.getApproximateCount();
            return GridDriver.this.interpolationInitializer.initialize(this.c, count);
        }

        @Override
        protected void refineAndNotify(RefinementTask task) {
            GridDriver.this.setCursorOrdinal(this.c, task.getKey());
            int result = this.c.position();
            GridDriver.this.interpolator.setPoint(task.getKey(), result);
            if (GridDriver.this.changeNotifier != null) {
                GridDriver.this.changeNotifier.run();
            }
        }

        @Override
        protected void acquireContext() {
            SystemCallContext sysContext = new SystemCallContext(((CallContext)GridDriver.this.closedCopy.callContext()).getCelesta(), "LyraCounterThread");
            this.c = GridDriver.this.closedCopy.getBufferCopy((CallContext)sysContext, GridDriver.this.columns);
            this.c.copyFiltersFrom(GridDriver.this.closedCopy);
            this.c.copyOrderFrom(GridDriver.this.closedCopy);
        }

        @Override
        protected void releaseContext() {
            ((CallContext)this.c.callContext()).close();
        }
    }
}

