/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel.grid;

import ru.curs.lyra.kernel.grid.LyraCollator;
import ru.curs.lyra.kernel.grid.LyraCollatorException;

public class LyraCollationElementIterator {
    private static final int PRIMARYORDERMASK = -65536;
    private static final int SECONDARYORDERMASK = 65280;
    private static final int TERTIARYORDERMASK = 255;
    private static final int PRIMARYORDERSHIFT = 16;
    private static final int SECONDARYORDERSHIFT = 8;
    private final String source;
    private final LyraCollator owner;
    private int i = 0;
    private int element;

    LyraCollationElementIterator(String source, LyraCollator owner) {
        this.source = source;
        this.owner = owner;
    }

    public boolean next() throws LyraCollatorException {
        while (this.i < this.source.length()) {
            char c = this.source.charAt(this.i);
            ++this.i;
            if (this.owner.isIgnored(c)) continue;
            this.element = this.owner.getElementCode(c);
            return true;
        }
        return false;
    }

    public int primaryOrder() {
        return (this.element & 0xFFFF0000) >>> 16;
    }

    public int secondaryOrder() {
        return (this.element & 0xFF00) >> 8;
    }

    public int tertiaryOrder() {
        return this.element & 0xFF;
    }
}

