/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.controller;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.SystemCallContext;
import ru.curs.lyra.dto.DataParams;
import ru.curs.lyra.dto.DataResult;
import ru.curs.lyra.dto.FormInstantiationParams;
import ru.curs.lyra.dto.MetaDataResult;
import ru.curs.lyra.service.LyraService;

@RestController
@RequestMapping(value={"/lyra"})
public final class LyraController {
    private final LyraService srv;

    public LyraController(LyraService srv) {
        this.srv = srv;
    }

    @PostMapping(value={"/metadata"})
    public MetaDataResult getMetadata(@RequestBody FormInstantiationParams formInstantiationParams) {
        SystemCallContext ctx = new SystemCallContext();
        return this.srv.getMetadata((CallContext)ctx, formInstantiationParams);
    }

    @PostMapping(value={"/data"})
    public ResponseEntity getData(@RequestBody DataParams dataParams) {
        SystemCallContext ctx = new SystemCallContext();
        DataResult dataResult = this.srv.getData((CallContext)ctx, dataParams.getFormInstantiationParams(), dataParams.getDataRetrievalParams());
        Object data = dataResult.getObjAddData() == null ? dataResult.getData() : dataResult.getObjAddData();
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Content-Type", "application/json;charset=UTF-8");
        int totalCount = dataParams.getDataRetrievalParams().getTotalCount();
        int firstIndex = dataParams.getDataRetrievalParams().getOffset();
        int lastIndex = dataParams.getDataRetrievalParams().getOffset() + dataParams.getDataRetrievalParams().getLimit() - 1;
        responseHeaders.set("Content-Range", String.format("items %s-%s/%s", firstIndex, lastIndex, totalCount));
        return new ResponseEntity(data, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }
}

