/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel.grid;

import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import ru.curs.lyra.kernel.grid.CollatorRulesLexer;
import ru.curs.lyra.kernel.grid.LyraCollationElementIterator;
import ru.curs.lyra.kernel.grid.LyraCollatorException;

public final class LyraCollator {
    private static final HashMap<String, LyraCollator> CACHE = new HashMap();
    private static final int BYTEMASK = 255;
    private static final int WORDMASK = 65535;
    private static final int PRIMARYORDERSHIFT = 16;
    private static final int SECONDARYORDERSHIFT = 8;
    private int primOrderCount;
    private int secOrderCount;
    private int terOrderCount;
    private final TreeMap<Integer, Character> codeToElement = new TreeMap();
    private final HashMap<Character, Integer> elementToCode = new HashMap();
    private final HashSet<Character> ignoredElements = new HashSet();
    private final String name;

    private LyraCollator(String rules, String name) {
        this.parseRules(rules);
        this.name = name;
    }

    public static synchronized LyraCollator getInstance(String rules, String name) {
        LyraCollator result = CACHE.get(rules);
        if (result == null) {
            result = new LyraCollator(rules, name);
            CACHE.put(rules, result);
        }
        return result;
    }

    private static int getElementCode(int primOrder, int secOrder, int terOrder) {
        return (primOrder & 0xFFFF) << 16 | (secOrder & 0xFF) << 8 | terOrder & 0xFF;
    }

    boolean isIgnored(char c) {
        return this.ignoredElements.contains(Character.valueOf(c));
    }

    int getElementCode(char c) throws LyraCollatorException {
        Integer e = this.elementToCode.get(Character.valueOf(c));
        if (e == null) {
            throw new LyraCollatorException(c);
        }
        return e;
    }

    char getElement(int primOrder, int secOrder, int terOrder) {
        if (primOrder < 0 || primOrder >= this.primOrderCount) {
            throw new IndexOutOfBoundsException();
        }
        if (secOrder < 0 || secOrder >= this.secOrderCount) {
            throw new IndexOutOfBoundsException();
        }
        if (terOrder < 0 || terOrder >= this.terOrderCount) {
            throw new IndexOutOfBoundsException();
        }
        int e = LyraCollator.getElementCode(primOrder, secOrder, terOrder);
        Character c = this.codeToElement.floorEntry(e).getValue();
        return c.charValue();
    }

    private void parseRules(String rules) {
        int value;
        this.primOrderCount = 0;
        this.secOrderCount = 0;
        this.terOrderCount = 0;
        int state = 0;
        int s = 0;
        int t = 0;
        char c = ' ';
        CollatorRulesLexer lexer = new CollatorRulesLexer(rules);
        block14: while ((value = lexer.next()) != -1) {
            switch (state) {
                case 0: {
                    switch (value) {
                        case 0: {
                            this.ignoredElements.add(Character.valueOf(lexer.getValue()));
                            continue block14;
                        }
                        case 1: {
                            state = 1;
                            continue block14;
                        }
                    }
                    continue block14;
                }
                case 1: {
                    switch (value) {
                        case 0: {
                            c = lexer.getValue();
                            continue block14;
                        }
                        case 1: {
                            this.putChar(s, t, c);
                            ++this.primOrderCount;
                            this.updateMaxSecOrder(s);
                            this.updateMaxTerOrder(t);
                            s = 0;
                            t = 0;
                            continue block14;
                        }
                        case 2: {
                            this.putChar(s, t, c);
                            ++s;
                            this.updateMaxTerOrder(t);
                            t = 0;
                            continue block14;
                        }
                        case 3: {
                            this.putChar(s, t, c);
                            ++t;
                            continue block14;
                        }
                    }
                    continue block14;
                }
            }
        }
        this.putChar(s, t, c);
        this.updateMaxTerOrder(t);
        this.updateMaxSecOrder(s);
        ++this.primOrderCount;
        ++this.secOrderCount;
        ++this.terOrderCount;
    }

    private void putChar(int s, int t, char c) {
        int e = LyraCollator.getElementCode(this.primOrderCount, s, t);
        this.codeToElement.put(e, Character.valueOf(c));
        this.elementToCode.put(Character.valueOf(c), e);
    }

    private void updateMaxSecOrder(int s) {
        if (s > this.secOrderCount) {
            this.secOrderCount = s;
        }
    }

    private void updateMaxTerOrder(int t) {
        if (t > this.terOrderCount) {
            this.terOrderCount = t;
        }
    }

    public int getPrimOrderCount() {
        return this.primOrderCount;
    }

    public int getSecOrderCount() {
        return this.secOrderCount;
    }

    public int getTerOrderCount() {
        return this.terOrderCount;
    }

    public LyraCollationElementIterator getCollationElementIterator(String source) {
        return new LyraCollationElementIterator(source, this);
    }

    public String getName() {
        return this.name;
    }
}

