/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel;

import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import ru.curs.lyra.kernel.RefinementTask;

public abstract class RefinementScheduler
implements Callable<Void> {
    private final DelayQueue<RefinementTask> queue = new DelayQueue();

    private RefinementTask freshest(RefinementTask task) {
        RefinementTask result = task;
        RefinementTask fresherTask = task;
        while (fresherTask != null) {
            if (fresherTask.isImmediate()) {
                return fresherTask;
            }
            result = fresherTask;
            fresherTask = (RefinementTask)this.queue.poll();
        }
        return result;
    }

    protected abstract boolean refineInterpolator();

    protected abstract void refineAndNotify(RefinementTask var1);

    protected abstract void acquireContext();

    protected abstract void releaseContext();

    public void setTask(RefinementTask task) {
        this.queue.put(task);
    }

    @Override
    public final Void call() throws InterruptedException {
        boolean block = false;
        this.acquireContext();
        while (true) {
            RefinementTask task;
            if (block) {
                this.releaseContext();
                task = this.freshest((RefinementTask)this.queue.take());
                this.acquireContext();
            } else {
                task = this.freshest((RefinementTask)this.queue.poll());
            }
            if (task == null) {
                block = !this.refineInterpolator();
                continue;
            }
            if (task.isImmediate()) {
                this.refineAndNotify(task);
                block = false;
                continue;
            }
            if (this.queue.size() > 0) {
                block = !this.refineInterpolator();
                continue;
            }
            this.refineAndNotify(task);
            block = false;
        }
    }
}

