/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel.grid;

import java.math.BigInteger;
import java.util.Optional;
import ru.curs.lyra.kernel.grid.KeyEnumerator;

public final class CompositeKeyEnumerator
extends KeyEnumerator {
    private final KeyEnumerator[] keys;

    public CompositeKeyEnumerator(KeyEnumerator ... kfm) {
        this.keys = kfm;
    }

    @Override
    public BigInteger cardinality() {
        if (this.keys.length == 0) {
            return BigInteger.ONE;
        }
        BigInteger result = this.keys[0].cardinality();
        for (int i = 1; i < this.keys.length; ++i) {
            result = result.multiply(this.keys[i].cardinality());
        }
        return result;
    }

    @Override
    public BigInteger getOrderValue() {
        if (this.keys.length == 0) {
            return BigInteger.ZERO;
        }
        BigInteger result = this.keys[0].getOrderValue();
        for (int i = 1; i < this.keys.length; ++i) {
            KeyEnumerator km = this.keys[i];
            result = result.multiply(km.cardinality()).add(km.getOrderValue());
        }
        return result;
    }

    @Override
    public void setOrderValue(BigInteger value) {
        if (this.keys.length == 0) {
            return;
        }
        BigInteger v = value;
        for (int i = this.keys.length - 1; i >= 0; --i) {
            BigInteger[] vr = v.divideAndRemainder(this.keys[i].cardinality());
            this.keys[i].setOrderValue(vr[1]);
            v = vr[0];
        }
    }

    @Override
    public void setValue(Object value) {
    }

    @Override
    public Object getValue() {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < this.keys.length; ++i) {
            if (i > 0) {
                sb.append(";");
            }
            sb.append(Optional.ofNullable(this.keys[i].getValue()).map(Object::toString).orElse("NULL"));
        }
        sb.append(")");
        return sb.toString();
    }
}

