/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel.grid;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.dbutils.adaptors.StaticDataAdaptor;
import ru.curs.lyra.kernel.grid.KeyEnumerator;
import ru.curs.lyra.kernel.grid.LyraCollationElementIterator;
import ru.curs.lyra.kernel.grid.LyraCollator;
import ru.curs.lyra.kernel.grid.LyraCollatorException;

public class VarcharFieldEnumerator
extends KeyEnumerator {
    static final List<String> CHARS = Arrays.asList("'", "-", "\u2013", "\u2014", " ", "!", "\"", "#", "$", "%", "&", "(", ")", "*", ",", ".", "/", ":", ";", "?", "@", "[", "\\", "]", "^", "_", "`", "{", "|", "}", "~", "\u00a6", "\u2018", "\u2019", "\u201a", "\u201c", "\u201d", "\u201e", "\u2039", "\u203a", "+", "<", "=", ">", "\u00ab", "\u00bb", "\u00a7", "\u00a9", "\u00ac", "\u00ae", "\u00b0", "\u2020", "\u2021", "\u2022", "\u2030", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "A", "b", "B", "c", "C", "d", "D", "e", "E", "f", "F", "g", "G", "h", "H", "i", "I", "j", "J", "k", "K", "l", "L", "m", "M", "n", "N", "\u2116", "o", "O", "p", "P", "q", "Q", "r", "R", "s", "S", "t", "T", "\u2122", "u", "U", "v", "V", "w", "W", "x", "X", "y", "Y", "z", "Z", "\u0430", "\u0410", "\u0431", "\u0411", "\u0432", "\u0412", "\u0433", "\u0413", "\u0434", "\u0414", "\u0435", "\u0415", "\u0451", "\u0401", "\u0436", "\u0416", "\u0437", "\u0417", "\u0438", "\u0418", "\u0439", "\u0419", "\u043a", "\u041a", "\u043b", "\u041b", "\u043c", "\u041c", "\u043d", "\u041d", "\u043e", "\u041e", "\u043f", "\u041f", "\u0440", "\u0420", "\u0441", "\u0421", "\u0442", "\u0422", "\u0443", "\u0423", "\u0444", "\u0424", "\u0445", "\u0425", "\u0446", "\u0426", "\u0447", "\u0427", "\u0448", "\u0428", "\u0449", "\u0429", "\u044a", "\u042a", "\u044b", "\u042b", "\u044c", "\u042c", "\u044d", "\u042d", "\u044e", "\u042e", "\u044f", "\u042f");
    private static final Map<StaticDataAdaptor, String> RULES = new HashMap<StaticDataAdaptor, String>();
    private static final int[][] EMPTY_STRING = new int[0][0];
    private final LyraCollator collator;
    private final int m;
    private final BigInteger[][] q;
    private final BigInteger c2;
    private final BigInteger c3;
    private int[][] min;
    private int[][] max;
    private BigInteger card;
    private BigInteger minOrd;
    private String value = "";

    public VarcharFieldEnumerator(StaticDataAdaptor staticDataAdaptor, int m) {
        this(staticDataAdaptor, m, true);
        this.min = EMPTY_STRING;
        this.max = new int[m][3];
        int p = this.collator.getPrimOrderCount() - 1;
        int s = this.collator.getSecOrderCount() - 1;
        int t = this.collator.getTerOrderCount() - 1;
        for (int i = 0; i < m; ++i) {
            this.max[i][0] = p;
            this.max[i][1] = s;
            this.max[i][2] = t;
        }
        this.minOrd = this.ord(this.min);
        this.card = this.ord(this.max).subtract(this.ord(this.min)).add(BigInteger.ONE);
    }

    public VarcharFieldEnumerator(StaticDataAdaptor staticDataAdaptor, String min, String max, int m) {
        this(staticDataAdaptor, m, true);
        this.setBounds(min, max);
    }

    private VarcharFieldEnumerator(StaticDataAdaptor staticDataAdaptor, int m, boolean setup) {
        if (m <= 0) {
            throw new IllegalArgumentException();
        }
        String rules = RULES.computeIfAbsent(staticDataAdaptor, this::calcRules);
        this.collator = LyraCollator.getInstance(rules, staticDataAdaptor.getClass().getSimpleName() + "Collator");
        BigInteger[] count = new BigInteger[]{BigInteger.valueOf(this.collator.getPrimOrderCount()), BigInteger.valueOf(this.collator.getSecOrderCount()), BigInteger.valueOf(this.collator.getTerOrderCount())};
        this.m = m;
        this.q = new BigInteger[m][3];
        for (int j = 0; j < 3; ++j) {
            this.q[m - 1][j] = BigInteger.ONE;
            for (int i = m - 2; i >= 0; --i) {
                this.q[i][j] = this.q[i + 1][j].multiply(count[j]).add(j == 0 ? BigInteger.ONE : BigInteger.ZERO);
            }
        }
        this.c2 = this.q[0][1].multiply(count[1]);
        this.c3 = this.q[0][2].multiply(count[2]);
    }

    public void setBounds(String min, String max) {
        this.min = this.toArray(min);
        this.max = this.toArray(max);
        this.minOrd = this.ord(this.min);
        this.card = this.ord(this.max).subtract(this.ord(this.min)).add(BigInteger.ONE);
    }

    private int[][] toArray(String str) {
        if (str.isEmpty()) {
            return EMPTY_STRING;
        }
        int[][] result = new int[str.length()][3];
        LyraCollationElementIterator i = this.collator.getCollationElementIterator(str);
        int j = 0;
        try {
            while (i.next()) {
                result[j][0] = i.primaryOrder();
                result[j][1] = i.secondaryOrder();
                result[j][2] = i.tertiaryOrder();
                ++j;
            }
        }
        catch (LyraCollatorException e) {
            throw new CelestaException("Error in string '%s': character '%s' is unknown for collator '%s'.", new Object[]{str, String.valueOf(e.getUnknownChar()), this.collator.getName()});
        }
        return result;
    }

    private BigInteger atomicOrd(int[][] s, int o) {
        BigInteger result = o == 0 ? BigInteger.valueOf(s.length) : BigInteger.ZERO;
        for (int i = 0; i < s.length; ++i) {
            result = result.add(this.q[i][o].multiply(BigInteger.valueOf(s[i][o])));
        }
        return result;
    }

    private BigInteger ord(int[][] s) {
        BigInteger[] o = new BigInteger[3];
        for (int i = 0; i < 3; ++i) {
            o[i] = this.atomicOrd(s, i);
        }
        return o[0].multiply(this.c2).add(o[1]).multiply(this.c3).add(o[2]);
    }

    @Override
    public BigInteger cardinality() {
        return this.card;
    }

    @Override
    public BigInteger getOrderValue() {
        int[][] arr = this.toArray(this.value);
        return this.ord(arr).subtract(this.minOrd);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException();
        }
        this.value = (String)value;
    }

    @Override
    public void setOrderValue(BigInteger value) {
        int i;
        BigInteger r = value.add(this.minOrd);
        if (r.equals(BigInteger.ZERO)) {
            this.value = "";
            return;
        }
        BigInteger[] components = new BigInteger[3];
        BigInteger[] cr = r.divideAndRemainder(this.c3);
        components[2] = cr[1];
        cr = cr[0].divideAndRemainder(this.c2);
        components[1] = cr[1];
        components[0] = cr[0];
        int[][] arr = new int[this.m][3];
        block0: for (int j = 0; j < 3; ++j) {
            r = components[j];
            for (i = 0; i < this.m; ++i) {
                if (j == 0) {
                    r = r.subtract(BigInteger.ONE);
                }
                cr = r.divideAndRemainder(this.q[i][j]);
                r = cr[1];
                int c = cr[0].intValue();
                if (c < 0) {
                    c = 0;
                } else if (c >= this.collator.getPrimOrderCount()) {
                    c = this.collator.getPrimOrderCount() - 1;
                }
                arr[i][j] = c;
                if (!r.equals(BigInteger.ZERO)) continue;
                if (j != 0 || i + 1 >= this.m) continue block0;
                arr[i + 1][j] = -1;
                continue block0;
            }
        }
        char[] buf = new char[this.m];
        for (i = 0; i < this.m && arr[i][0] >= 0; ++i) {
            buf[i] = this.collator.getElement(arr[i][0], arr[i][1], arr[i][2]);
        }
        this.value = new String(buf, 0, i);
    }

    private String calcRules(StaticDataAdaptor staticDataAdaptor) {
        List data = staticDataAdaptor.selectStaticStrings(CHARS, "\"id\"", "ASC");
        StringBuilder ruleBuilder = new StringBuilder();
        ruleBuilder.append("<'" + (String)data.get(0) + "'");
        for (int i = 1; i < data.size(); ++i) {
            String right;
            String left = (String)data.get(i - 1);
            int comparisonResult = staticDataAdaptor.compareStrings(left, right = (String)data.get(i));
            if (comparisonResult < 0) {
                if (staticDataAdaptor.compareStrings(right, left + "1") < 0) {
                    if (left.equalsIgnoreCase(right)) {
                        ruleBuilder.append(",");
                    } else {
                        ruleBuilder.append(";");
                    }
                } else {
                    ruleBuilder.append("<");
                }
            } else if (comparisonResult == 0) {
                if (left.equalsIgnoreCase(right)) {
                    ruleBuilder.append(",");
                } else {
                    ruleBuilder.append(";");
                }
            }
            ruleBuilder.append("'" + right + "'");
        }
        return ruleBuilder.toString();
    }
}

