/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.service;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.curs.celesta.CallContext;
import ru.curs.celesta.dbutils.BasicCursor;
import ru.curs.celesta.dbutils.Cursor;
import ru.curs.lyra.dto.DataResult;
import ru.curs.lyra.dto.DataRetrievalParams;
import ru.curs.lyra.dto.Labels;
import ru.curs.lyra.dto.LyraGridAddInfo;
import ru.curs.lyra.kernel.BasicGridForm;
import ru.curs.lyra.kernel.LyraFieldType;
import ru.curs.lyra.kernel.LyraFieldValue;
import ru.curs.lyra.kernel.LyraFormData;
import ru.curs.lyra.service.LyraGridScrollBack;

class DataFactory {
    static final String INTERNAL_COLUMN_ADDDATA = "internalAddData";
    private static final String RECVERSION = "recversion";
    private static final String DGRID_NEW_POSITION = "dgridNewPosition";
    private static final String DGRID_NEW_POSITION_ID = "dgridNewPositionId";
    private static final String INTERNAL_COLUMN_ID = "internalId";
    private static final int LYRA_EXACT_TOTALCOUNT_DELTA = 20;
    private final CallContext ctx;
    private final BasicGridForm<? extends BasicCursor> basicGridForm;
    private final DataRetrievalParams dataRetrievalParams;
    private final LyraGridAddInfo lyraGridAddInfo;
    private int position;
    private final int lyraApproxTotalCountBeforeGetRows;
    private int lyraApproxTotalCountAfterGetRows;
    private final boolean lyraExactTotalCount;
    private final int dgridDelta;
    private List<LyraFormData> records;

    DataFactory(CallContext ctx, BasicGridForm<? extends BasicCursor> aBasicGridForm, DataRetrievalParams aDataRetrievalParams) {
        this.ctx = ctx;
        this.basicGridForm = aBasicGridForm;
        this.dataRetrievalParams = aDataRetrievalParams;
        if (this.dataRetrievalParams.isSortingOrFilteringChanged()) {
            ((LyraGridScrollBack)this.basicGridForm.getChangeNotifier()).setLyraGridAddInfo(new LyraGridAddInfo());
        }
        this.lyraGridAddInfo = ((LyraGridScrollBack)this.basicGridForm.getChangeNotifier()).getLyraGridAddInfo();
        this.dgridDelta = this.dataRetrievalParams.getOffset() - this.dataRetrievalParams.getDgridOldPosition();
        int approxCount = this.basicGridForm.getApproxTotalCount();
        if (approxCount < this.basicGridForm.getGridHeight() + 20) {
            this.lyraApproxTotalCountBeforeGetRows = this.basicGridForm.rec(ctx).count();
            this.lyraExactTotalCount = true;
        } else {
            this.lyraApproxTotalCountBeforeGetRows = approxCount;
            this.lyraExactTotalCount = false;
        }
        this.setRecords();
        this.setTotalCount();
        this.printLog();
        this.setLyraGridAddInfo();
    }

    private void setRecords() {
        if (this.dataRetrievalParams.isFirstLoading()) {
            if (this.dataRetrievalParams.getSelectKey() == null) {
                this.records = this.basicGridForm.getRows(this.ctx, 0);
            } else {
                if (this.dataRetrievalParams.isSortingOrFilteringChanged()) {
                    this.basicGridForm.getRows(this.ctx, 0);
                }
                this.records = this.basicGridForm.setPosition(this.ctx, this.dataRetrievalParams.getSelectKey());
            }
        } else if (this.dataRetrievalParams.getRefreshId() == null) {
            if (this.dataRetrievalParams.getOffset() == 0) {
                this.position = 0;
            } else if (this.lyraApproxTotalCountBeforeGetRows <= 50000) {
                this.position = this.dataRetrievalParams.getOffset();
            } else if (Math.abs(this.dgridDelta) < 100) {
                this.position = this.basicGridForm.getTopVisiblePosition() + this.dgridDelta;
            } else if (Math.abs(this.dataRetrievalParams.getOffset() - 50000) < 100) {
                this.position = this.lyraApproxTotalCountBeforeGetRows - this.dataRetrievalParams.getLimit();
            } else {
                double d = this.lyraApproxTotalCountBeforeGetRows;
                d /= 50000.0;
                this.position = (int)Math.round(d *= (double)this.dataRetrievalParams.getOffset());
            }
            this.records = this.basicGridForm.getRows(this.ctx, this.position);
        } else {
            this.records = this.basicGridForm.setPosition(this.ctx, this.dataRetrievalParams.getRefreshId());
        }
    }

    private void setTotalCount() {
        this.lyraApproxTotalCountAfterGetRows = this.lyraExactTotalCount ? this.lyraApproxTotalCountBeforeGetRows : this.basicGridForm.getApproxTotalCount();
        if (this.records.size() < this.dataRetrievalParams.getLimit()) {
            this.dataRetrievalParams.setTotalCount(this.records.size());
        } else {
            this.dataRetrievalParams.setTotalCount(Math.min(this.lyraApproxTotalCountAfterGetRows, 50000));
        }
    }

    private void printLog() {
        System.out.println("LyraGridDataFactory.ddddddddddddd1");
        System.out.println("className: " + this.basicGridForm.getClass().getSimpleName());
        System.out.println("date: " + LocalDateTime.now());
        System.out.println("params.isFirstLoading(): " + this.dataRetrievalParams.isFirstLoading());
        System.out.println("position: " + this.position);
        System.out.println("lyraNewPosition: " + this.basicGridForm.getTopVisiblePosition());
        System.out.println("lyraOldPosition: " + this.lyraGridAddInfo.getLyraOldPosition());
        System.out.println("lyraExactTotalCount: " + this.lyraExactTotalCount);
        System.out.println("lyraApproxTotalCountBeforeGetRows: " + this.lyraApproxTotalCountBeforeGetRows);
        System.out.println("lyraApproxTotalCountAfterGetRows: " + this.lyraApproxTotalCountAfterGetRows);
        System.out.println("basicGridForm.getApproxTotalCount: " + this.basicGridForm.getApproxTotalCount());
        System.out.println("records.size(): " + this.records.size());
        System.out.println("dGridLimit(): " + this.dataRetrievalParams.getLimit());
        System.out.println("dGridTotalCount: " + this.dataRetrievalParams.getTotalCount());
    }

    private void setLyraGridAddInfo() {
        this.lyraGridAddInfo.setLyraOldPosition(this.basicGridForm.getTopVisiblePosition());
        this.lyraGridAddInfo.setDgridOldTotalCount(this.dataRetrievalParams.getTotalCount());
    }

    public DataResult dataResult() {
        int length;
        int from;
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        if (this.dgridDelta > 0) {
            from = Math.max(this.records.size() - this.dataRetrievalParams.getLimit(), 0);
            length = this.records.size();
        } else {
            from = 0;
            length = Math.min(this.records.size(), this.dataRetrievalParams.getLimit());
        }
        for (int i = from; i < length; ++i) {
            LyraFormData rec = this.records.get(i);
            HashMap<String, Object> obj = new HashMap<String, Object>();
            for (LyraFieldValue lyraFieldValue : rec.getFields()) {
                Object objValue;
                if ("recordProperties".equalsIgnoreCase(lyraFieldValue.getName())) {
                    obj.put("recordProperties", lyraFieldValue.getValue());
                    continue;
                }
                switch (lyraFieldValue.meta().getType()) {
                    case DATETIME: {
                        objValue = this.getStringValueOfDate(lyraFieldValue);
                        break;
                    }
                    case INT: 
                    case REAL: {
                        objValue = this.getStringValueOfNumber(lyraFieldValue);
                        break;
                    }
                    default: {
                        objValue = lyraFieldValue.getValue();
                    }
                }
                obj.put(lyraFieldValue.getName(), objValue);
            }
            obj.put(INTERNAL_COLUMN_ID, rec.getKeyValues());
            obj.put(RECVERSION, String.valueOf(rec.getRecversion()));
            data.add(obj);
        }
        if (this.dataRetrievalParams.isFirstLoading() && data.size() > 0 && this.basicGridForm.getTopVisiblePosition() > 0) {
            double d = this.basicGridForm.getTopVisiblePosition();
            d = d / (double)this.lyraApproxTotalCountAfterGetRows * (double)this.lyraGridAddInfo.getDgridOldTotalCount();
            int dgridNewPosition = (int)d;
            ((Map)data.get(0)).put(DGRID_NEW_POSITION, dgridNewPosition);
            Object c = this.basicGridForm.rec(this.ctx);
            if (c instanceof Cursor) {
                ((Map)data.get(0)).put(DGRID_NEW_POSITION_ID, ((Cursor)c).getCurrentKeyValues());
            } else {
                ((Map)data.get(0)).put(DGRID_NEW_POSITION_ID, c.getCurrentValues()[0]);
            }
        }
        DataResult dataResult = new DataResult();
        Labels labels = new Labels();
        labels.setHeader(this.basicGridForm.getFormProperties().getHeader());
        labels.setFooter(this.basicGridForm.getFormProperties().getFooter());
        if (data.size() > 0) {
            ((Map)data.get(0)).put(INTERNAL_COLUMN_ADDDATA, labels);
            dataResult.setData(data);
        } else {
            HashMap<String, Labels> objAddData = new HashMap<String, Labels>();
            objAddData.put(INTERNAL_COLUMN_ADDDATA, labels);
            dataResult.setObjAddData(objAddData);
        }
        return dataResult;
    }

    private String getStringValueOfDate(LyraFieldValue lyraFieldValue) {
        if (lyraFieldValue.getValue() == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(lyraFieldValue.meta().getDateFormat());
        return dateFormat.format(lyraFieldValue.getValue());
    }

    private String getStringValueOfNumber(LyraFieldValue lyraFieldValue) {
        if (lyraFieldValue.getValue() == null) {
            return null;
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        if (lyraFieldValue.meta().getType() == LyraFieldType.INT) {
            nf.setMinimumFractionDigits(0);
            nf.setMaximumFractionDigits(0);
        } else {
            nf.setMinimumFractionDigits(lyraFieldValue.meta().getScale());
            nf.setMaximumFractionDigits(lyraFieldValue.meta().getScale());
        }
        String decimalSeparator = lyraFieldValue.meta().getDecimalSeparator();
        String groupingSeparator = lyraFieldValue.meta().getGroupingSeparator();
        if (decimalSeparator != null || groupingSeparator != null) {
            DecimalFormat df = (DecimalFormat)nf;
            DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance();
            if (decimalSeparator != null) {
                dfs.setDecimalSeparator(decimalSeparator.charAt(0));
            }
            if (groupingSeparator != null) {
                if (groupingSeparator.isEmpty()) {
                    nf.setGroupingUsed(false);
                } else {
                    dfs.setGroupingSeparator(groupingSeparator.charAt(0));
                }
            }
            df.setDecimalFormatSymbols(dfs);
        }
        return nf.format(lyraFieldValue.getValue());
    }

    boolean isLyraExactTotalCount() {
        return this.lyraExactTotalCount;
    }

    BasicGridForm<? extends BasicCursor> getBasicGridForm() {
        return this.basicGridForm;
    }

    int getLyraApproxTotalCountBeforeGetRows() {
        return this.lyraApproxTotalCountBeforeGetRows;
    }
}

