/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.lyra.kernel.grid;

import java.math.BigInteger;
import ru.curs.lyra.kernel.grid.KeyEnumerator;
import ru.curs.lyra.kernel.grid.NullsFirst;
import ru.curs.lyra.kernel.grid.NullsLast;

public abstract class NullableFieldEnumerator
extends KeyEnumerator {
    private final KeyEnumerator parent;
    private boolean valueIsNull = true;

    NullableFieldEnumerator(KeyEnumerator parent) {
        this.parent = parent;
    }

    @Override
    public BigInteger cardinality() {
        return this.getParent().cardinality().add(BigInteger.ONE);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setValueIsNull(true);
        } else {
            this.setValueIsNull(false);
            this.getParent().setValue(value);
        }
    }

    @Override
    public Object getValue() {
        return this.isValueIsNull() ? null : this.getParent().getValue();
    }

    boolean isValueIsNull() {
        return this.valueIsNull;
    }

    void setValueIsNull(boolean valueIsNull) {
        this.valueIsNull = valueIsNull;
    }

    KeyEnumerator getParent() {
        return this.parent;
    }

    public static NullableFieldEnumerator create(boolean nullsFirst, KeyEnumerator parent) {
        return nullsFirst ? new NullsFirst(parent) : new NullsLast(parent);
    }
}

