/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import ru.cwcode.commands.ArgumentSearchResult;
import ru.cwcode.commands.Command;
import ru.cwcode.commands.api.Sender;

public abstract class CommandParser {
    final Command node;

    public CommandParser(Command command) {
        this.node = command;
    }

    public boolean onCommandExecute(@NotNull Sender sender, String label, String[] args) {
        int deep;
        Result parseResult = CommandParser.parse(this.node, sender, args);
        Command foundedCommand = parseResult.getCommand();
        ArgumentSearchResult argumentSearchResult = foundedCommand.searchForArgumentSet(sender, args = args.length > (deep = parseResult.getDeep()) ? Arrays.copyOfRange(args, deep, args.length) : new String[]{});
        if (argumentSearchResult.isFounded()) {
            foundedCommand.onExecute(sender, args, argumentSearchResult.getFounded());
        } else {
            foundedCommand.onError(sender, args, argumentSearchResult);
        }
        return true;
    }

    public static Result parse(Command parentCommand, Sender sender, String ... args) {
        Command foundedCommand;
        int deep = 0;
        while (args.length > 0 && (foundedCommand = parentCommand.getSubcommandFor(args[0], sender)) != null) {
            ++deep;
            parentCommand = foundedCommand;
            args = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
        }
        return new Result(parentCommand, deep);
    }

    static class Result {
        Command command;
        int deep;

        public Result(Command command, int deep) {
            this.command = command;
            this.deep = deep;
        }

        public Command getCommand() {
            return this.command;
        }

        public int getDeep() {
            return this.deep;
        }
    }
}

