/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.animation;

import java.time.Duration;
import org.bukkit.Bukkit;
import tkachgeek.tkachutils.animation.timingFunction.TimingFunction;
import tkachgeek.tkachutils.animation.timingFunction.TimingFunctions;

public class AnimationProperties {
    final double start;
    final double end;
    final Duration duration;
    long frames;
    long currentFrame = -1L;
    double step;
    double frameDelay;
    boolean animationEnded = false;
    TimingFunction timingFunction = TimingFunctions.linear;
    boolean reversed = false;

    public AnimationProperties(double start, double end, Duration duration) {
        this.start = start;
        this.end = end;
        this.duration = duration;
        this.setFrames(duration.toMillis() / 50L);
        if (start > end) {
            this.reversed();
        }
    }

    public AnimationProperties setFrames(long frames) {
        this.frames = frames;
        this.step = Math.abs((this.end - this.start) / (double)frames);
        this.frameDelay = (double)this.duration.toMillis() / (double)frames;
        return this;
    }

    public AnimationProperties reversed() {
        this.reversed = true;
        return this;
    }

    public AnimationProperties setTimingFunction(TimingFunction timingFunction) {
        this.timingFunction = timingFunction;
        return this;
    }

    public void reset() {
        this.currentFrame = -1L;
        this.animationEnded = false;
    }

    public boolean hasNextFrame() {
        return !this.animationEnded;
    }

    public double nextFrame() {
        ++this.currentFrame;
        this.animationEnded = this.currentFrame == this.frames;
        return this.getValue();
    }

    public double getValue() {
        return this.start + (this.reversed ? 1.0 - this.calculateValue() : this.calculateValue());
    }

    private double calculateValue() {
        return (double)this.frames * this.timingFunction.transform((double)this.currentFrame / (double)this.frames) * this.step;
    }

    public double frameDelay() {
        return this.frameDelay * (double)this.currentFrame;
    }

    public long frameDelayInTicks() {
        return (long)(this.frameDelay / 50.0 * (double)this.currentFrame);
    }

    public long lastFrameDelayInTicks() {
        return (long)(this.frameDelay / 50.0 * (double)this.frames);
    }

    public void debug() {
        Bukkit.broadcastMessage((String)("frame: " + this.currentFrame + ", frames: " + this.frames + ", value: " + this.getValue() + ", step: " + this.step + ", delay: " + this.frameDelay()));
    }
}

