/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.benchmark;

import java.util.HashMap;
import tkachgeek.tkachutils.benchmark.BenchmarkChannel;

public class Benchmark {
    static HashMap<String, BenchmarkChannel> benchmarks = new HashMap();
    static int iterationCount = 200;
    static boolean enabled = true;

    public static void stopAt(int iterationCount) {
        Benchmark.iterationCount = iterationCount;
    }

    public static void enable() {
        enabled = true;
    }

    public static void disable() {
        enabled = false;
    }

    public static BenchmarkChannel getChannel(String name) {
        if (!benchmarks.containsKey(name)) {
            benchmarks.put(name, new BenchmarkChannel());
        }
        return benchmarks.get(name);
    }

    public static void stage(String channel, String stage) {
        if (!enabled) {
            return;
        }
        long time = System.nanoTime();
        Benchmark.getChannel(channel).newStage(stage, time);
    }

    protected static void stop(String channel, long time) {
        if (!enabled) {
            return;
        }
        Benchmark.getChannel(channel).stopLastStage(time);
    }

    public static void newIteration(String channel) {
        if (!enabled) {
            return;
        }
        long time = System.nanoTime();
        Benchmark.stop(channel, time);
        if (iterationCount < Benchmark.getChannel((String)channel).iterations.size()) {
            Benchmark.print(channel);
            return;
        }
        Benchmark.getChannel(channel).newIteration(time);
    }

    public static void print(String channel) {
        if (!enabled) {
            return;
        }
        Benchmark.getChannel(channel).print(channel);
        Benchmark.removeChannel(channel);
    }

    private static void removeChannel(String channel) {
        if (!enabled) {
            return;
        }
        benchmarks.remove(channel);
    }
}

