/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.colors;

import java.util.List;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;

public class ColorUtils {
    private static final List<String> colors = List.of("0123456789abcdef".split(""));

    @NotNull
    public static TextColor lerpManyColors(int i, float sectionLen, TextColor ... colors) {
        return TextColor.lerp((float)i % sectionLen / sectionLen, colors[(int)Math.floor((float)i / sectionLen)], colors[(int)Math.ceil((float)i / sectionLen)]);
    }

    public static TextColor lerpManyColors(float lerp, TextColor ... colors) {
        double sectionLen = 255.0 * (double)(colors.length - 1);
        int i = (int)(sectionLen * (double)(colors.length - 1) * (double)lerp);
        return TextColor.lerp((float)((double)i % sectionLen / sectionLen), colors[(int)Math.floor((double)i / sectionLen)], colors[(int)Math.ceil((double)i / sectionLen)]);
    }

    public static boolean isColor(String color) {
        return colors.contains(color);
    }

    public static List<String> getColors() {
        return colors;
    }
}

