/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.datetime;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StringToDuration {
    public static final HashMap<Character, TemporalUnit> units = new HashMap();

    public static boolean isValid(String st) {
        try {
            for (char c : st.toCharArray()) {
                if (c >= '0' && c <= '9' || StringToDuration.hasUnit(c) || c == 't') continue;
                return false;
            }
            StringToDuration.parse(st);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Duration parse(String line) {
        HashMap<Character, String> parts = StringToDuration.splitParts(line);
        Duration duration = Duration.ofSeconds(0L);
        for (Map.Entry<Character, String> part : parts.entrySet()) {
            if (StringToDuration.hasUnit(part.getKey().charValue())) {
                duration = duration.plus(Duration.of(Long.parseLong(part.getValue()), units.get(part.getKey())));
                continue;
            }
            if (part.getKey().charValue() != 't') continue;
            duration = duration.plus(Duration.ofMillis(Long.parseLong(part.getValue()) * 50L));
        }
        return duration;
    }

    @NotNull
    private static HashMap<Character, String> splitParts(String line) {
        StringBuilder currentPart = new StringBuilder();
        HashMap<Character, String> parts = new HashMap<Character, String>();
        if (line.isEmpty()) {
            return parts;
        }
        for (char c : line.toCharArray()) {
            if (c >= '0' && c <= '9') {
                currentPart.append(c);
                continue;
            }
            if (!StringToDuration.hasUnit(c) && c != 't') continue;
            if (currentPart.length() > 0) {
                parts.put(Character.valueOf(c), currentPart.toString());
            }
            currentPart.setLength(0);
        }
        return parts;
    }

    private static boolean hasUnit(char c) {
        return units.containsKey(Character.valueOf(c));
    }

    static {
        units.put(Character.valueOf('y'), ChronoUnit.YEARS);
        units.put(Character.valueOf('M'), ChronoUnit.MONTHS);
        units.put(Character.valueOf('w'), ChronoUnit.WEEKS);
        units.put(Character.valueOf('d'), ChronoUnit.DAYS);
        units.put(Character.valueOf('h'), ChronoUnit.HOURS);
        units.put(Character.valueOf('m'), ChronoUnit.MINUTES);
        units.put(Character.valueOf('s'), ChronoUnit.SECONDS);
    }
}

