/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.dynamicBossBar.broadcast;

import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import tkachgeek.tkachutils.dynamicBossBar.broadcast.BroadcastBossBar;
import tkachgeek.tkachutils.scheduler.Scheduler;

public class BroadcastBossBarManager {
    ConcurrentLinkedQueue<BroadcastBossBar> bars = new ConcurrentLinkedQueue();
    JavaPlugin plugin;

    public BroadcastBossBarManager(JavaPlugin plugin, boolean async, int delay) {
        this.plugin = plugin;
        Scheduler.create().async(async).infinite().perform(this::tick).register(plugin, delay);
    }

    public void add(BroadcastBossBar bar) {
        this.removeBar(bar.getUUID());
        this.bars.add(bar);
    }

    private void tick() {
        if (this.bars == null || this.bars.isEmpty()) {
            return;
        }
        this.bars.removeIf(bar -> {
            if (bar.getShouldRemove().get().booleanValue()) {
                bar.hideAll();
                return true;
            }
            bar.update();
            return false;
        });
    }

    public void removeBar(UUID bar) {
        this.getBossBarEntries().removeIf(x -> {
            if (x.getUUID().equals(bar)) {
                x.hideAll();
                return true;
            }
            return false;
        });
    }

    @NotNull
    public Queue<BroadcastBossBar> getBossBarEntries() {
        return this.bars;
    }

    public void removeBar(BroadcastBossBar bar) {
        this.getBossBarEntries().removeIf(x -> {
            if (x.getUUID().equals(bar.getUUID())) {
                x.hideAll();
                return true;
            }
            return false;
        });
    }
}

