/*
 * Decompiled with CFR 0.152.
 */
package tkachgeek.tkachutils.flow;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import tkachgeek.tkachutils.flow.FlowAction;
import tkachgeek.tkachutils.flow.FlowIfAction;
import tkachgeek.tkachutils.flow.FlowSimpleAction;
import tkachgeek.tkachutils.flow.FlowWhileAction;

public class Flow<T> {
    List<FlowAction<T>> actions = new ArrayList<FlowAction<T>>();
    T object;
    private boolean suppressExceptions = true;

    public Flow(T object) {
        this.object = object;
    }

    public static <T> Flow<T> of(T object) {
        return new Flow<T>(object);
    }

    public Flow<T> doNotSuppressExceptions() {
        this.suppressExceptions = false;
        return this;
    }

    public Flow<T> next(Consumer<T> action) {
        this.actions.add(new FlowSimpleAction<T>(action));
        return this;
    }

    public Flow<T> doUntil(Consumer<T> action, Predicate<T> predicate) {
        this.actions.add(new FlowWhileAction<T>(action, predicate));
        return this;
    }

    public Flow<T> doIf(Consumer<T> action, Predicate<T> predicate) {
        this.actions.add(new FlowIfAction<T>(action, predicate));
        return this;
    }

    public Flow<T> sleep(int millis) {
        this.next(x -> {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
        return this;
    }

    public BukkitTask startAsync(JavaPlugin plugin) {
        return Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> this.startHere(plugin));
    }

    public BukkitTask startSync(JavaPlugin plugin) {
        return Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> this.startHere(plugin));
    }

    public BukkitTask startAsync(JavaPlugin plugin, int delay) {
        return Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, () -> this.startHere(plugin), (long)delay);
    }

    public BukkitTask startSync(JavaPlugin plugin, int delay) {
        return Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> this.startHere(plugin), (long)delay);
    }

    public BukkitTask startAsyncTimer(JavaPlugin plugin, int delay, int period) {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, () -> this.startHere(plugin), (long)delay, (long)period);
    }

    public BukkitTask startSyncTimer(JavaPlugin plugin, int delay, int period) {
        return Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> this.startHere(plugin), (long)delay, (long)period);
    }

    public void startHere(JavaPlugin plugin) {
        block3: {
            try {
                for (FlowAction<T> action : this.actions) {
                    action.run(this.object);
                }
            }
            catch (Exception ignored) {
                if (this.suppressExceptions) break block3;
                ignored.printStackTrace();
            }
        }
    }
}

