/*
 * Decompiled with CFR 0.152.
 */
package ru.cwcode.commands.color;

import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.HSVLike;
import ru.cwcode.commands.color.ColorGenerationStrategy;

public class ColoredScheme
implements ColorGenerationStrategy {
    TextColor selectedColor;
    private final TextColor main;
    private final TextColor argument;
    private final TextColor optional;
    private final TextColor subcommand;
    private final TextColor written;
    private final TextColor permissions;
    private final TextColor accent;
    private final TextColor argumentWithNoPermissions;
    private final TextColor optionalWithNoPermissions;
    private final TextColor subcommandWithNoPermissions;
    private final TextColor writtenWithNoPermissions;
    private final TextColor permissionsWithNoPermissions;
    private final TextColor accentWithNoPermissions;

    public ColoredScheme(TextColor selectedColor) {
        this.selectedColor = selectedColor;
        this.main = this.generateColor(TextColor.fromHexString("#00a6f0"));
        this.argument = this.generateColor(TextColor.fromHexString("#00baff"));
        this.optional = this.generateColor(TextColor.fromHexString("#02d7ff"));
        this.subcommand = this.generateColor(TextColor.fromHexString("#0098dc"));
        this.written = this.generateColor(TextColor.fromHexString("#007ab5"));
        this.permissions = this.generateColor(TextColor.fromHexString("#055080"));
        this.accent = this.generateColor(TextColor.fromHexString("#8adaff"));
        this.argumentWithNoPermissions = this.generateColor(TextColor.fromHexString("#FF2C00"));
        this.optionalWithNoPermissions = this.generateColor(TextColor.fromHexString("#FF1800"));
        this.subcommandWithNoPermissions = this.generateColor(TextColor.fromHexString("#FF2C00"));
        this.writtenWithNoPermissions = this.generateColor(TextColor.fromHexString("#FF3100"));
        this.permissionsWithNoPermissions = this.generateColor(TextColor.fromHexString("#C83000"));
        this.accentWithNoPermissions = this.generateColor(TextColor.fromHexString("#FF9C84"));
    }

    private TextColor generateColor(TextColor base) {
        HSVLike selectedHSV = this.selectedColor.asHSV();
        HSVLike baseHSV = base.asHSV();
        HSVLike of = HSVLike.of(selectedHSV.h(), baseHSV.s(), baseHSV.v());
        return TextColor.color(of);
    }

    @Override
    public TextColor main() {
        return this.main;
    }

    @Override
    public TextColor argument(boolean canPerformedBy) {
        return canPerformedBy ? this.argument : this.argumentWithNoPermissions;
    }

    @Override
    public TextColor optional(boolean canPerformedBy) {
        return canPerformedBy ? this.optional : this.optionalWithNoPermissions;
    }

    @Override
    public TextColor subcommand(boolean canPerformedBy) {
        return canPerformedBy ? this.subcommand : this.subcommandWithNoPermissions;
    }

    @Override
    public TextColor written(boolean canPerformedBy) {
        return canPerformedBy ? this.written : this.writtenWithNoPermissions;
    }

    @Override
    public TextColor permissions(boolean canPerformedBy) {
        return canPerformedBy ? this.permissions : this.permissionsWithNoPermissions;
    }

    @Override
    public TextColor accent(boolean canPerformedBy) {
        return canPerformedBy ? this.accent : this.accentWithNoPermissions;
    }
}

